<?php

namespace Monnify\MonnifyLaravel\Services;

use GuzzleHttp\Client;
use InvalidArgumentException;
use Monnify\MonnifyLaravel\Enums\HttpMethod;
use Monnify\MonnifyLaravel\Validators\InvoiceValidator;

class InvoiceService extends BaseService
{
    private InvoiceValidator $validator;

    public function __construct(Client $client)
    {
        parent::__construct($client);
        $this->validator = new InvoiceValidator();
    }

    public function create(array $data): array
    {
        $this->validator->validateAccount($data);
        return $this->makeRequest(
            HttpMethod::POST,
            '/api/v1/invoice/create',
            $data
        );
    }

    public function get(string $invoiceReference): array
    {
        if (empty($invoiceReference)) {
            throw new InvalidArgumentException('Invoice Reference must be provided.');
        }

        return $this->makeRequest(
            HttpMethod::GET,
            '/api/v1/invoice/'.$invoiceReference.'/details'
        );
    }

    public function all(): array
    {
        return $this->makeRequest(
            HttpMethod::GET,
            '/api/v1/invoice/all'
        );
    }

    public function cancel(string $invoiceReference): array
    {
        if (empty($invoiceReference)) {
            throw new InvalidArgumentException('Invoice Reference must be provided.');
        }

        return $this->makeRequest(
            HttpMethod::DELETE,
            '/api/v1/invoice/'.$invoiceReference.'/cancel'
        );
    }

    public function attachReservedAccount(array $data): array
    {
        $this->validator->validateAccount($data);
        return $this->makeRequest(
            HttpMethod::POST,
            '/api/v1/invoice/create',
            $data
        );
    }
}