<?php

use App\Http\Controllers\ProfileController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\DataController;
use App\Http\Controllers\AirtimeController;
use App\Http\Controllers\WalletController;
use App\Http\Controllers\TransactionController;
use App\Http\Controllers\CableTVController;
use Illuminate\Support\Facades\Route;
use Inertia\Inertia;

// Welcome page (public)
Route::get('/', function () {
    return Inertia::render('Welcome');
});

// ==================== AUTHENTICATED ROUTES ====================
Route::middleware(['auth', 'verified'])->group(function () {

    // ========== DASHBOARD ==========
    Route::get('/dashboard', [DashboardController::class, 'index'])->name('dashboard');

    // ========== PROFILE ==========
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');
    Route::post('/profile/avatar', [ProfileController::class, 'updateAvatar'])->name('profile.avatar.update');
    Route::delete('/profile/avatar', [ProfileController::class, 'deleteAvatar'])->name('profile.avatar.delete');

    // ========== WALLET & FUNDING ==========
    Route::get('/fund-wallet', [WalletController::class, 'fund'])->name('fund.wallet');
    Route::get('/wallet/deposit', [WalletController::class, 'deposit'])->name('wallet.deposit');
    Route::post('/wallet/deposit', [WalletController::class, 'initializeDeposit'])->name('wallet.deposit.initialize');
    Route::get('/wallet/deposit/callback', [WalletController::class, 'depositCallback'])->name('wallet.deposit.callback');
    Route::get('/wallet', [WalletController::class, 'walletHistory'])->name('wallet');
    Route::get('/wallet/history', [WalletController::class, 'walletHistory'])->name('wallet.history');

    // ========== DATA PURCHASE ==========
    Route::get('/buy-data', [DataController::class, 'index'])->name('buy.data'); // Original name
    Route::get('/data/plans/{network}', [DataController::class, 'getPlans'])->name('data.plans');
    Route::post('/buy-data', [DataController::class, 'purchase'])->name('data.purchase');
    Route::post('/check-vendor-balance', [DataController::class, 'checkVendorBalance'])->name('check.vendor.balance');

    // ========== AIRTIME PURCHASE ==========
    Route::get('/buy-airtime', [AirtimeController::class, 'index'])->name('buy.airtime'); // Original name
    Route::post('/buy-airtime', [AirtimeController::class, 'purchase'])->name('airtime.purchase');

    // ========== TRANSACTIONS ==========
    Route::get('/transactions', [TransactionController::class, 'index'])->name('transactions');
    Route::get('/transactions/{transaction}/receipt', [TransactionController::class, 'downloadReceipt'])->name('transactions.receipt');
    Route::post('/transactions/{transaction}/check-status', [AirtimeController::class, 'checkStatus'])->name('transactions.check-status');


    // ========== CABLE TV  ==========
    Route::get('/cable-tv', [CableTVController::class, 'index'])->name('cable.index');
    Route::get('/cable/packages/{provider}', [CableTVController::class, 'getPackages']);
    Route::post('/cable/verify', [CableTVController::class, 'verifySmartcard']);
    Route::post('/cable/purchase', [CableTVController::class, 'purchase']);
    Route::post('/cable/callback', [CableTVController::class, 'callback'])->name('cable.callback');

    });

// ==================== WEBHOOKS & CALLBACKS (NO AUTH) ====================

// Monnify Webhooks
Route::post('/monnify/webhook', [WalletController::class, 'handleWebhook'])->name('monnify.webhook');

// Monnify Callbacks
Route::post('/monnify/callback', [WalletController::class, 'handleMonnifyCallback'])->name('monnify.callback.post');
Route::get('/monnify/callback', [WalletController::class, 'handleMonnifyRedirect'])->name('monnify.callback.get');

// ClubKonnect Callbacks
Route::post('/clubkonnect/callback', [AirtimeController::class, 'callback'])->name('clubkonnect.callback');
Route::post('/clubkonnect/data-callback', [DataController::class, 'callback'])->name('clubkonnect.data.callback');

// Airtime callback route
Route::post('/airtime/callback', [AirtimeController::class, 'callback'])->name('airtime.callback');

require __DIR__ . '/auth.php';
