{{-- resources/views/layouts/app.blade.php --}}
<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    {{-- Dynamic Favicon --}}
    @include('components.dynamic-favicon')

    {{-- Title with dynamic app name --}}
    <title>{{ config('app.name', 'Laravel') }} - @yield('title')</title>

    {{-- Other meta tags --}}

</head>

<body>
    {{-- Header with dynamic logo --}}
    <header>
        <a href="{{ url('/') }}">
            <x-dynamic-logo class="h-8 w-auto" />
        </a>
    </header>

    {{-- Content --}}
    <main>
        @yield('content')
    </main>
</body>

</html>