{{-- resources/views/components/dynamic-logo.blade.php --}}
@php
use App\Models\Setting;

$logo = Setting::getValue('branding.logo');
$logoSvg = Setting::getValue('branding.logo_svg');
$hasLogo = ($logo || $logoSvg);
@endphp

@if($hasLogo)
@if($logoSvg)
{!! $logoSvg !!}
@elseif($logo)
<img src="{{ Storage::url($logo) }}" alt="{{ config('app.name') }}" {{ $attributes }}>
@endif
@else
<img src="{{ asset('logo.svg') }}" alt="{{ config('app.name') }}" {{ $attributes }}>
@endif