{{-- resources/views/components/dynamic-favicon.blade.php --}}
@php
use App\Models\Setting;

$favicon = Setting::getValue('branding.favicon');
$faviconSvg = Setting::getValue('branding.favicon_svg');
$hasFavicon = ($favicon || $faviconSvg);
@endphp

@if($hasFavicon)
@if($faviconSvg)
<link rel="icon" href="data:image/svg+xml,{{ rawurlencode($faviconSvg) }}" type="image/svg+xml">
@elseif($favicon)
<link rel="icon" href="{{ route('dynamic.favicon') }}?v={{ time() }}" type="image/x-icon">
@endif
@else
<link rel="icon" href="{{ asset('favicon.ico') }}" type="image/x-icon">
@endif