"use client";

import { Link, router, usePage } from "@inertiajs/react";
import {
    BadgeCheck,
    Bell,
    ChevronsUpDown,
    CreditCard,
    LogOut,
    Sparkles,
} from "lucide-react";

import { Avatar, AvatarFallback, AvatarImage } from "@/Components/ui/avatar";
import {
    DropdownMenu,
    DropdownMenuContent,
    DropdownMenuGroup,
    DropdownMenuItem,
    DropdownMenuLabel,
    DropdownMenuSeparator,
    DropdownMenuTrigger,
} from "@/Components/ui/dropdown-menu";
import {
    SidebarMenu,
    SidebarMenuButton,
    SidebarMenuItem,
    useSidebar,
} from "@/Components/ui/sidebar";

export function NavUser() {
    const { isMobile } = useSidebar();
    const { auth } = usePage().props;
    const user = auth.user;

    // Function to get user initials
    const getInitials = (name: string) => {
        if (!name) return "U";
        return (
            name
                .split(" ")
                .map((word) => word[0] || "")
                .join("")
                .toUpperCase()
                .slice(0, 2) || "US"
        );
    };

    // Log for debugging
    console.log("NavUser - User data:", {
        name: user.name,
        avatar: user.avatar,
        avatar_url: user.avatar_url,
        has_avatar: !!user.avatar,
        avatar_type: typeof user.avatar,
    });

    return (
        <SidebarMenu>
            <SidebarMenuItem>
                <DropdownMenu>
                    <DropdownMenuTrigger asChild>
                        <SidebarMenuButton
                            size="lg"
                            className="data-[state=open]:bg-sidebar-accent data-[state=open]:text-sidebar-accent-foreground"
                        >
                            <Avatar className="h-8 w-8 rounded-lg">
                                <AvatarImage
                                    src={user.avatar_url || user.avatar}
                                    alt={user.name}
                                    onError={(e) => {
                                        console.error(
                                            "NavUser - Avatar image failed to load:",
                                            e.currentTarget.src
                                        );
                                        // Fallback to initials
                                        e.currentTarget.style.display = "none";
                                    }}
                                />
                                <AvatarFallback className="rounded-lg bg-primary/10 text-primary font-semibold">
                                    {getInitials(user.name)}
                                </AvatarFallback>
                            </Avatar>

                            <div className="grid flex-1 text-left text-sm leading-tight">
                                <span className="truncate font-medium">
                                    {user.name}
                                </span>
                                <span className="truncate text-xs">
                                    {user.email}
                                </span>
                            </div>

                            <ChevronsUpDown className="ml-auto size-4" />
                        </SidebarMenuButton>
                    </DropdownMenuTrigger>

                    <DropdownMenuContent
                        className="w-(--radix-dropdown-menu-trigger-width) min-w-56 rounded-lg"
                        side={isMobile ? "bottom" : "right"}
                        align="end"
                        sideOffset={4}
                    >
                        <DropdownMenuLabel className="p-0 font-normal">
                            <div className="flex items-center gap-2 px-1 py-1.5 text-left text-sm">
                                <Avatar className="h-8 w-8 rounded-lg">
                                    <AvatarImage
                                        src={user.avatar_url || user.avatar}
                                        alt={user.name}
                                        onError={(e) => {
                                            console.error(
                                                "Dropdown - Avatar image failed to load:",
                                                e.currentTarget.src
                                            );
                                            e.currentTarget.style.display =
                                                "none";
                                        }}
                                    />
                                    <AvatarFallback className="rounded-lg bg-primary/10 text-primary font-semibold">
                                        {getInitials(user.name)}
                                    </AvatarFallback>
                                </Avatar>
                                <div className="grid flex-1 text-left text-sm leading-tight">
                                    <span className="truncate font-medium">
                                        {user.name}
                                    </span>
                                    <span className="truncate text-xs">
                                        {user.email}
                                    </span>
                                </div>
                            </div>
                        </DropdownMenuLabel>
                        <DropdownMenuSeparator />
                        <DropdownMenuGroup>
                            <DropdownMenuItem>
                                <Sparkles />
                                Upgrade Your Package
                            </DropdownMenuItem>
                        </DropdownMenuGroup>
                        <DropdownMenuSeparator />
                        <DropdownMenuGroup>
                            <Link href={route("profile.edit")}>
                                <DropdownMenuItem>
                                    <BadgeCheck />
                                    Account
                                </DropdownMenuItem>
                            </Link>

                            {/* <DropdownMenuItem>
                                <CreditCard />
                                Billing
                            </DropdownMenuItem> */}
                            </DropdownMenuGroup>
                        <DropdownMenuSeparator />
                        <DropdownMenuItem
                            onClick={() => router.post(route("logout"))}
                        >
                            <LogOut />
                            Log out
                        </DropdownMenuItem>
                    </DropdownMenuContent>
                </DropdownMenu>
            </SidebarMenuItem>
        </SidebarMenu>
    );
}
