"use client";

import * as React from "react";
import {
    SquareTerminal,
    Receipt,
    Send,
    Phone,
    Wallet,
    History,
    Shield,
    Tv, // Add this line
} from "lucide-react";
import { Link, usePage } from "@inertiajs/react";
import ApplicationLogo from "@/Components/ApplicationLogo";

import { NavMain } from "@/Layouts/Partials/NavMain";
import { NavUser } from "@/Layouts/Partials/NavUser";
import {
    Sidebar,
    SidebarContent,
    SidebarFooter,
    SidebarHeader,
    SidebarMenu,
    SidebarMenuButton,
    SidebarMenuItem,
    useSidebar,
} from "@/Components/ui/sidebar";

interface NavItem {
    title: string;
    url: string;
    icon: React.ComponentType<any>;
    isActive: boolean;
    isAdminOnly?: boolean;
    external?: boolean;
}

export function AppSidebar({ ...props }: React.ComponentProps<typeof Sidebar>) {
    const { state } = useSidebar();
    const { url: currentPath } = usePage();
    const { auth } = usePage().props as { auth: { user?: any } };

    const navMain: NavItem[] = [
        {
            title: "Dashboard",
            url: route("dashboard"),
            icon: SquareTerminal,
            isActive: route().current("dashboard") || false,
        },
        {
            title: "Transaction History",
            url: route("transactions"),
            icon: Receipt,
            isActive: route().current("transactions") || false,
        },
        {
            title: "Buy Data",
            url: route("buy.data"),
            icon: Send,
            isActive: route().current("buy.data") || false,
        },
        {
            title: "Buy Airtime",
            url: route("buy.airtime"),
            icon: Phone,
            isActive: route().current("buy.airtime") || false,
        },
        {
            title: "Buy Cable TV",
            url: route("cable.index"),
            icon: Tv, // Now this will work
            isActive:
                route().current("cable.index") ||
                route().current("cable.*") ||
                false,
        },
        {
            title: "Fund Wallet",
            url: route("fund.wallet"),
            icon: Wallet,
            isActive: route().current("fund.wallet") || false,
        },
        {
            title: "Wallet History",
            url: route("wallet"),
            icon: History,
            isActive: route().current("wallet") || false,
        },
        // Admin panel link
        {
            title: "Admin",
            url: "/admin",
            icon: Shield,
            isActive: currentPath.startsWith("/admin"),
            isAdminOnly: true,
            external: false,
        },
    ];

    // Filter nav items based on user permissions
    const filteredNavMain = navMain.filter((item) => {
        if (item.isAdminOnly) {
            return auth.user && auth.user.is_admin; // Adjust this based on your user model
        }
        return true;
    });

    return (
        <Sidebar
            variant="inset"
            collapsible="icon"
            className="border-r border-gray-200"
            {...props}
        >
            <SidebarHeader>
                <SidebarMenu>
                    <SidebarMenuItem>
                        <SidebarMenuButton
                            size="lg"
                            asChild
                            className="group-data-[state=collapsed]:justify-center group-data-[state=collapsed]:px-2"
                        >
                            <Link href={route("dashboard")}>
                                {/* Logo Container - Always visible */}
                                <div className="flex aspect-square size-8 items-center justify-center rounded-lg">
                                    <ApplicationLogo className="size-6 text-blue-600" />
                                </div>

                                {/* Text that hides when collapsed */}
                                <div
                                    className="grid flex-1 text-left text-sm leading-tight transition-all duration-300 
                                              group-data-[state=collapsed]:opacity-0 group-data-[state=collapsed]:hidden"
                                >
                                    <span className="truncate font-medium text-gray-800">
                                        HOPAY DATA HUB
                                    </span>
                                    <span className="truncate text-xs text-gray-500">
                                        Quick way for Topup
                                    </span>
                                </div>
                            </Link>
                        </SidebarMenuButton>
                    </SidebarMenuItem>
                </SidebarMenu>
            </SidebarHeader>

            <SidebarContent>
                <NavMain items={filteredNavMain} />
            </SidebarContent>

            <SidebarFooter>
                <NavUser />
            </SidebarFooter>
        </Sidebar>
    );
}
