// @/Components/ApplicationLogo.tsx
import { SVGAttributes } from "react";

interface ApplicationLogoProps extends SVGAttributes<SVGElement> {
    className?: string;
}

export default function ApplicationLogo({
    className = "",
    ...props
}: ApplicationLogoProps) {
    return (
        <svg
            {...props}
            className={className}
            viewBox="0 0 316 316"
            xmlns="http://www.w3.org/2000/svg"
            shapeRendering="geometricPrecision"
            textRendering="geometricPrecision"
            imageRendering="optimizeQuality"
            fillRule="evenodd"
            clipRule="evenodd"
        >
            <g id="Layer_x0020_1">
                <g id="_1121115216">
                    <g>
                        <path
                            fill="#F84616"
                            fillRule="nonzero"
                            d="M220.41 191.73c31.31,16.45 58.57,15.04 71.87,31.77 13.3,16.74 15.42,44.09 -5.35,61.9 -19.33,16.57 -48.15,9.39 -64.2,-12.88 -12.5,-17.34 1.15,-58.21 -2.32,-80.79z"
                        />
                        <path
                            fill="#FB811E"
                            fillRule="nonzero"
                            d="M220.61 191.39c-23.67,-12.43 -44.28,-11.36 -54.33,-24.02 -10.05,-12.65 -11.66,-33.32 4.04,-46.79 14.62,-12.53 36.4,-7.1 48.54,9.74 9.45,13.11 -0.88,44 1.75,61.07z"
                        />
                    </g>
                    <g>
                        <path
                            fill="#7D2FD3"
                            fillRule="nonzero"
                            d="M132.26 129.93c27.13,-22.69 54.07,-27.07 63.53,-46.23 9.47,-19.17 5.76,-46.35 -18.3,-59.38 -22.39,-12.11 -49.05,1 -60.03,26.16 -8.55,19.59 13.43,56.65 14.8,79.45z"
                        />
                        <path
                            fill="#02A7FF"
                            fillRule="nonzero"
                            d="M132.52 130.22c-20.5,17.15 -40.87,20.46 -48.02,34.95 -7.16,14.49 -4.36,35.04 13.83,44.88 16.93,9.16 37.08,-0.75 45.38,-19.77 6.47,-14.81 -10.15,-42.82 -11.19,-60.06z"
                        />
                    </g>
                    <g>
                        <path
                            fill="#05B179"
                            fillRule="nonzero"
                            d="M126.88 237.48c-26.26,23.69 -34.36,49.75 -54.66,56.44 -20.31,6.69 -46.7,-0.78 -56.23,-26.42 -8.87,-23.87 7.84,-48.43 34.29,-55.79 20.6,-5.73 54.21,21.22 76.6,25.77z"
                        />
                        <path
                            fill="#FACF1E"
                            fillRule="nonzero"
                            d="M127.13 237.78c19.86,-17.91 25.98,-37.61 41.33,-42.66 15.34,-5.06 35.3,0.58 42.5,19.97 6.7,18.04 -5.92,36.61 -25.92,42.17 -15.57,4.33 -40.99,-16.04 -57.91,-19.48z"
                        />
                    </g>
                </g>
                <path
                    fill="none"
                    d="M103.72 103.9l107.14 0c0.4,0 0.72,0.32 0.72,0.72l0 107.45c0,0.4 -0.32,0.73 -0.72,0.73l-107.14 0 0 -108.9z"
                />
                <rect
                    fill="none"
                    x="-1.26"
                    y="1.39"
                    width="318.51"
                    height="313.22"
                />
            </g>
        </svg>
    );
}
