<?php
echo "<h2>PHP Extension Check</h2>";

$required = ['intl', 'zip', 'mbstring', 'openssl', 'curl', 'fileinfo', 'exif', 'pdo_mysql', 'mysqli'];
foreach ($required as $ext) {
    $status = extension_loaded($ext) ? '✅ ENABLED' : '❌ MISSING';
    echo "<b>$ext</b>: $status<br>";
}

echo "<h2>Testing Number Formatting</h2>";
try {
    $test = Illuminate\Support\Number::format(1000);
    echo "✅ Number formatting WORKING: $test";
} catch (Exception $e) {
    echo "❌ Number formatting FAILED: " . $e->getMessage();
}

echo "<h2>PHP Info</h2>";
echo "PHP Version: " . PHP_VERSION . "<br>";
echo "Loaded php.ini: " . php_ini_loaded_file() . "<br>";
