<?php


// database/seeders/SettingsSeeder.php
namespace Database\Seeders;

use App\Models\Setting;
use Illuminate\Database\Seeder;

class SettingsSeeder extends Seeder
{
    public function run()
    {
        $settings = [
            // ============ GENERAL/BRANDING SETTINGS ============
            [
                'key' => 'app.name',
                'value' => env('APP_NAME', 'VTU Service'),
                'type' => 'string',
                'group' => 'general',
                'category' => 'branding',
                'is_encrypted' => false,
                'is_sensitive' => false,
                'input_type' => 'text',
                'description' => 'Application name',
                'help_text' => 'Displayed throughout the site',
            ],
            [
                'key' => 'app.url',
                'value' => env('APP_URL', 'http://localhost:8000'),
                'type' => 'string',
                'group' => 'general',
                'category' => 'system',
                'is_encrypted' => false,
                'is_sensitive' => false,
                'input_type' => 'url',
                'description' => 'Application URL',
                'help_text' => 'Base URL for all links',
            ],

            // ============ BRANDING FILES ============
            [
                'key' => 'branding.favicon',
                'value' => null,
                'type' => 'string',
                'group' => 'branding',
                'category' => 'files',
                'is_encrypted' => false,
                'is_sensitive' => false,
                'input_type' => 'file',
                'description' => 'Website favicon',
                'help_text' => 'Upload .ico or .png file (16x16 or 32x32 pixels)',
                'validation_rules' => ['nullable', 'mimes:ico,png,svg', 'max:2048'],
            ],
            [
                'key' => 'branding.favicon_svg',
                'value' => null,
                'type' => 'string',
                'group' => 'branding',
                'category' => 'files',
                'is_encrypted' => false,
                'is_sensitive' => false,
                'input_type' => 'code',
                'description' => 'Favicon SVG code',
                'help_text' => 'Alternative: Paste SVG code for favicon',
            ],
            [
                'key' => 'branding.logo',
                'value' => null,
                'type' => 'string',
                'group' => 'branding',
                'category' => 'files',
                'is_encrypted' => false,
                'is_sensitive' => false,
                'input_type' => 'image',
                'description' => 'Website logo',
                'help_text' => 'Upload PNG, JPG or SVG logo. Recommended: SVG for best quality.',
                'validation_rules' => ['nullable', 'image', 'mimes:png,jpg,jpeg,svg', 'max:2048'],
            ],
            [
                'key' => 'branding.logo_svg',
                'value' => null,
                'type' => 'string',
                'group' => 'branding',
                'category' => 'files',
                'is_encrypted' => false,
                'is_sensitive' => false,
                'input_type' => 'code',
                'description' => 'Logo SVG code',
                'help_text' => 'Alternative: Paste SVG code for logo',
            ],

            // ============ MONNIFY SETTINGS ============
            [
                'key' => 'payment.monnify.base_url',
                'value' => env('MONNIFY_BASE_URL', 'https://sandbox.monnify.com'),
                'type' => 'string',
                'group' => 'payment',
                'category' => 'monnify',
                'is_encrypted' => false,
                'is_sensitive' => false,
                'input_type' => 'url',
                'description' => 'Monnify API Base URL',
                'help_text' => 'Use https://sandbox.monnify.com for testing, https://api.monnify.com for live',
            ],
            [
                'key' => 'payment.monnify.api_key',
                'value' => env('MONNIFY_API_KEY', ''),
                'type' => 'string',
                'group' => 'payment',
                'category' => 'monnify',
                'is_encrypted' => true,
                'is_sensitive' => true,
                'input_type' => 'password',
                'description' => 'Monnify API Key',
                'help_text' => 'Get from Monnify dashboard. Starts with MK_TEST_ for sandbox',
            ],
            [
                'key' => 'payment.monnify.secret_key',
                'value' => env('MONNIFY_SECRET_KEY', ''),
                'type' => 'string',
                'group' => 'payment',
                'category' => 'monnify',
                'is_encrypted' => true,
                'is_sensitive' => true,
                'input_type' => 'password',
                'description' => 'Monnify Secret Key',
                'help_text' => 'Keep this secure! Never share it.',
            ],
            [
                'key' => 'payment.monnify.contract_code',
                'value' => env('MONNIFY_CONTRACT_CODE', ''),
                'type' => 'string',
                'group' => 'payment',
                'category' => 'monnify',
                'is_encrypted' => false,
                'is_sensitive' => true,
                'input_type' => 'text',
                'description' => 'Monnify Contract Code',
                'help_text' => 'Your contract code from Monnify',
            ],
            [
                'key' => 'payment.monnify.wallet_account',
                'value' => env('MONNIFY_WALLET_ACCOUNT_NUMBER', ''),
                'type' => 'string',
                'group' => 'payment',
                'category' => 'monnify',
                'is_encrypted' => false,
                'is_sensitive' => true,
                'input_type' => 'text',
                'description' => 'Wallet Account Number',
                'help_text' => 'Monnify wallet account number',
            ],
            [
                'key' => 'payment.monnify.sandbox',
                'value' => env('MONNIFY_SANDBOX', true),
                'type' => 'boolean',
                'group' => 'payment',
                'category' => 'monnify',
                'is_encrypted' => false,
                'is_sensitive' => false,
                'input_type' => 'toggle',
                'description' => 'Sandbox Mode',
                'help_text' => 'Enable for testing, disable for live transactions',
            ],

            // ============ CLUBKONNECT SETTINGS ============
            [
                'key' => 'payment.clubkonnect.user_id',
                'value' => env('CLUBKONNECT_USER_ID', ''),
                'type' => 'string',
                'group' => 'payment',
                'category' => 'clubkonnect',
                'is_encrypted' => false,
                'is_sensitive' => true,
                'input_type' => 'text',
                'description' => 'ClubKonnect User ID',
                'help_text' => 'Your ClubKonnect user ID',
            ],
            [
                'key' => 'payment.clubkonnect.api_key',
                'value' => env('CLUBKONNECT_API_KEY', ''),
                'type' => 'string',
                'group' => 'payment',
                'category' => 'clubkonnect',
                'is_encrypted' => true,
                'is_sensitive' => true,
                'input_type' => 'password',
                'description' => 'ClubKonnect API Key',
                'help_text' => 'Keep this secure! Never share it.',
            ],
            [
                'key' => 'payment.clubkonnect.test_mode',
                'value' => env('CLUBKONNECT_TEST_MODE', false),
                'type' => 'boolean',
                'group' => 'payment',
                'category' => 'clubkonnect',
                'is_encrypted' => false,
                'is_sensitive' => false,
                'input_type' => 'toggle',
                'description' => 'Test Mode',
                'help_text' => 'Enable for testing',
            ],
            [
                'key' => 'payment.clubkonnect.test_success_rate',
                'value' => env('CLUBKONNECT_TEST_SUCCESS_RATE', 100),
                'type' => 'integer',
                'group' => 'payment',
                'category' => 'clubkonnect',
                'is_encrypted' => false,
                'is_sensitive' => false,
                'input_type' => 'number',
                'description' => 'Test Success Rate',
                'help_text' => 'Percentage of successful transactions in test mode (0-100)',
            ],

            // ============ BUSINESS SETTINGS ============
            [
                'key' => 'payment.test_mode',
                'value' => env('TEST_MODE', false),
                'type' => 'boolean',
                'group' => 'payment',
                'category' => 'general',
                'is_encrypted' => false,
                'is_sensitive' => false,
                'input_type' => 'toggle',
                'description' => 'Global Test Mode',
                'help_text' => 'Enable to test all payment methods without real money',
            ],
            [
                'key' => 'payment.skip_balance_check',
                'value' => env('SKIP_BALANCE_CHECK', false),
                'type' => 'boolean',
                'group' => 'payment',
                'category' => 'general',
                'is_encrypted' => false,
                'is_sensitive' => false,
                'input_type' => 'toggle',
                'description' => 'Skip Balance Check',
                'help_text' => 'Skip user balance verification for orders',
            ],

            // ============ COMPANY BANK DETAILS ============
            [
                'key' => 'company.bank.account_number',
                'value' => env('COMPANY_BANK_ACCOUNT_NUMBER', ''),
                'type' => 'string',
                'group' => 'company',
                'category' => 'bank',
                'is_encrypted' => false,
                'is_sensitive' => true,
                'input_type' => 'text',
                'description' => 'Bank Account Number',
                'help_text' => 'Company bank account for direct transfers',
            ],
            [
                'key' => 'company.bank.name',
                'value' => env('COMPANY_BANK_NAME', ''),
                'type' => 'string',
                'group' => 'company',
                'category' => 'bank',
                'is_encrypted' => false,
                'is_sensitive' => false,
                'input_type' => 'text',
                'description' => 'Bank Name',
                'help_text' => 'Name of the bank',
            ],
            [
                'key' => 'company.bank.account_name',
                'value' => env('COMPANY_BANK_ACCOUNT_NAME', ''),
                'type' => 'string',
                'group' => 'company',
                'category' => 'bank',
                'is_encrypted' => false,
                'is_sensitive' => true,
                'input_type' => 'text',
                'description' => 'Account Name',
                'help_text' => 'Name on the bank account',
            ],
            [
                'key' => 'company.bank.transfer_notes',
                'value' => env('COMPANY_BANK_TRANSFER_NOTES', ''),
                'type' => 'text',
                'group' => 'company',
                'category' => 'bank',
                'is_encrypted' => false,
                'is_sensitive' => false,
                'input_type' => 'textarea',
                'description' => 'Transfer Instructions',
                'help_text' => 'Instructions shown to users for bank transfers',
            ],
        ];

        foreach ($settings as $setting) {
            Setting::updateOrCreate(
                ['key' => $setting['key']],
                $setting
            );
        }
    }
}