<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;

class DatabaseSeeder extends Seeder
{
    public function run(): void
    {
        $this->call([
            // Core tables
            NetworkSeeder::class,

            // ClubKonnect products ( )
            ClubKonnectAirtimeSeeder::class,
            ClubKonnectDataSeeder::class,
            CableTVPackagesSeeder::class,
        ]);

        $this->command->info('🎉 Database seeding completed successfully!');

        // Display summary
        $this->displaySummary();
    }

    private function displaySummary()
    {
        $this->command->info("\n📊 SEEDING SUMMARY:");
        $this->command->info("==================");

        $networks = \App\Models\Network::count();
        $airtimeProducts = \App\Models\Product::where('provider', 'clubkonnect')
            ->where('type', 'airtime')
            ->count();
        $dataProducts = \App\Models\Product::where('provider', 'clubkonnect')
            ->where('type', 'data')
            ->count();

        $this->command->info("   📶 Networks: {$networks}");
        $this->command->info("   📞 Airtime Products: {$airtimeProducts}");
        $this->command->info("   📱 Data Products: {$dataProducts}");
        $this->command->info("   👥 Users: 2 (Admin + Customer)");

        $this->command->info("\n🔗 Login Credentials:");
        $this->command->info("   📧 Admin Email: admin@vtusite.com");
        $this->command->info("   🔑 Admin Password: password123");
        $this->command->info("   👛 Admin Wallet: ₦10,000.00");

        $this->command->info("\n   📧 Customer Email: customer@vtusite.com");
        $this->command->info("   🔑 Customer Password: password123");
        $this->command->info("   👛 Customer Wallet: ₦5,000.00");
    }
}
