<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;

class ClubKonnectDataSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $now = Carbon::now();

        // Clear existing data plans
        DB::table('products')->where('type', 'data')->delete();

        // Define network mapping
        $networks = [
            '01' => ['code' => '01', 'name' => 'MTN', 'provider_code' => '01'],
            '02' => ['code' => '02', 'name' => 'Glo', 'provider_code' => '02'],
            '03' => ['code' => '03', 'name' => '9mobile', 'provider_code' => '03'],
            '04' => ['code' => '04', 'name' => 'Airtel', 'provider_code' => '04'],
        ];

        // MTN Data Plans
        $mtnPlans = [
            ['plan_id' => '500.0', 'description' => '500 MB - 7 days (SME)', 'price' => 404.00, 'validity' => '7 days', 'data_size' => '500 MB'],
            ['plan_id' => '1000.0', 'description' => '1 GB - 7 days (SME)', 'price' => 567.00, 'validity' => '7 days', 'data_size' => '1 GB'],
            ['plan_id' => '2000.0', 'description' => '2 GB - 7 days (SME)', 'price' => 1134.00, 'validity' => '7 days', 'data_size' => '2 GB'],
            ['plan_id' => '3000.0', 'description' => '3 GB - 7 days (SME)', 'price' => 1680.00, 'validity' => '7 days', 'data_size' => '3 GB'],
            ['plan_id' => '5000.0', 'description' => '5 GB - 7 days (SME)', 'price' => 2540.00, 'validity' => '7 days', 'data_size' => '5 GB'],
            ['plan_id' => '100.01', 'description' => '110MB Daily Plan - 1 day (Awoof Data)', 'price' => 97.00, 'validity' => '1 day', 'data_size' => '110 MB'],
            ['plan_id' => '200.01', 'description' => '230MB Daily Plan - 1 day (Awoof Data)', 'price' => 194.00, 'validity' => '1 day', 'data_size' => '230 MB'],
            ['plan_id' => '350.01', 'description' => '500MB Daily Plan - 1 day (Awoof Data)', 'price' => 339.50, 'validity' => '1 day', 'data_size' => '500 MB'],
            ['plan_id' => '500.01', 'description' => '1GB Daily Plan + 1.5mins. - 1 day (Awoof Data)', 'price' => 485.00, 'validity' => '1 day', 'data_size' => '1 GB'],
            ['plan_id' => '750.01', 'description' => '2.5GB Daily Plan - 1 day (Awoof Data)', 'price' => 727.50, 'validity' => '1 day', 'data_size' => '2.5 GB'],
            ['plan_id' => '900.01', 'description' => '2.5GB 2-Day Plan - 2 days (Awoof Data)', 'price' => 873.00, 'validity' => '2 days', 'data_size' => '2.5 GB'],
            ['plan_id' => '1000.01', 'description' => '3.2GB 2-Day Plan - 2 days (Awoof Data)', 'price' => 970.00, 'validity' => '2 days', 'data_size' => '3.2 GB'],
            ['plan_id' => '500.02', 'description' => '500MB Weekly Plan - 7 days (Direct Data)', 'price' => 485.00, 'validity' => '7 days', 'data_size' => '500 MB'],
            ['plan_id' => '800.01', 'description' => '1GB Weekly Plan - 7 days (Direct Data)', 'price' => 776.00, 'validity' => '7 days', 'data_size' => '1 GB'],
            ['plan_id' => '1000.03', 'description' => '1.5GB Weekly Plan - 7 days (Direct Data)', 'price' => 970.00, 'validity' => '7 days', 'data_size' => '1.5 GB'],
            ['plan_id' => '1500.03', 'description' => '3.5GB Weekly Plan - 7 days (Direct Data)', 'price' => 1455.00, 'validity' => '7 days', 'data_size' => '3.5 GB'],
            ['plan_id' => '2500.01', 'description' => '6GB Weekly Plan - 7 days (Direct Data)', 'price' => 2425.00, 'validity' => '7 days', 'data_size' => '6 GB'],
            ['plan_id' => '3500.01', 'description' => '11GB Weekly Bundle - 7 days (Direct Data)', 'price' => 3395.00, 'validity' => '7 days', 'data_size' => '11 GB'],
            ['plan_id' => '1500.02', 'description' => '2GB+2mins Monthly Plan - 30 days (Direct Data)', 'price' => 1455.00, 'validity' => '30 days', 'data_size' => '2 GB'],
            ['plan_id' => '2000.01', 'description' => '2.7GB+2mins Monthly Plan - 30 days (Direct Data)', 'price' => 1940.00, 'validity' => '30 days', 'data_size' => '2.7 GB'],
            ['plan_id' => '2500.02', 'description' => '3.5GB+5mins Monthly Plan - 30 days (Direct Data)', 'price' => 2425.00, 'validity' => '30 days', 'data_size' => '3.5 GB'],
            ['plan_id' => '3500.02', 'description' => '7GB Monthly Plan - 30 days (Direct Data)', 'price' => 3395.00, 'validity' => '30 days', 'data_size' => '7 GB'],
            ['plan_id' => '4500.01', 'description' => '10GB+10mins Monthly Plan - 30 days (Direct Data)', 'price' => 4365.00, 'validity' => '30 days', 'data_size' => '10 GB'],
            ['plan_id' => '5500.01', 'description' => '12.5GB Monthly Plan - 30 days (Direct Data)', 'price' => 5335.00, 'validity' => '30 days', 'data_size' => '12.5 GB'],
            ['plan_id' => '6500.01', 'description' => '16.5GB+10mins Monthly Plan - 30 days (Direct Data)', 'price' => 6305.00, 'validity' => '30 days', 'data_size' => '16.5 GB'],
            ['plan_id' => '7500.01', 'description' => '20GB Monthly Plan - 30 days (Direct Data)', 'price' => 7275.00, 'validity' => '30 days', 'data_size' => '20 GB'],
            ['plan_id' => '9000.01', 'description' => '25GB Monthly Plan - 30 days (Direct Data)', 'price' => 8730.00, 'validity' => '30 days', 'data_size' => '25 GB'],
            ['plan_id' => '11000.01', 'description' => '36GB Monthly Plan - 30 days (Direct Data)', 'price' => 10670.00, 'validity' => '30 days', 'data_size' => '36 GB'],
            ['plan_id' => '18000.01', 'description' => '75GB Monthly Plan - 30 days (Direct Data)', 'price' => 17460.00, 'validity' => '30 days', 'data_size' => '75 GB'],
            ['plan_id' => '35000.01', 'description' => '165GB Monthly Plan - 30 days (Direct Data)', 'price' => 33950.00, 'validity' => '30 days', 'data_size' => '165 GB'],
            ['plan_id' => '40000.01', 'description' => '150GB 2-Month Plan - 60 days (Direct Data)', 'price' => 38800.00, 'validity' => '60 days', 'data_size' => '150 GB'],
            ['plan_id' => '5000.01', 'description' => '20GB Weekly Plan - 7 days (Direct Data)', 'price' => 4850.00, 'validity' => '7 days', 'data_size' => '20 GB'],
            ['plan_id' => '90000.03', 'description' => '480GB 3-Month Plan - 90 days (Direct Data)', 'price' => 87300.00, 'validity' => '90 days', 'data_size' => '480 GB'],
        ];

        // Airtel Data Plans
        $airtelPlans = [
            ['plan_id' => '499.91', 'description' => '1GB - 1 day (Awoof Data)', 'price' => 484.91, 'validity' => '1 day', 'data_size' => '1 GB'],
            ['plan_id' => '599.91', 'description' => '1.5GB - 2 days (Awoof Data)', 'price' => 581.91, 'validity' => '2 days', 'data_size' => '1.5 GB'],
            ['plan_id' => '749.91', 'description' => '2GB - 2 days (Awoof Data)', 'price' => 727.41, 'validity' => '2 days', 'data_size' => '2 GB'],
            ['plan_id' => '999.91', 'description' => '3GB - 2 days (Awoof Data)', 'price' => 969.91, 'validity' => '2 days', 'data_size' => '3 GB'],
            ['plan_id' => '1499.91', 'description' => '5GB - 2 days (Awoof Data)', 'price' => 1454.91, 'validity' => '2 days', 'data_size' => '5 GB'],
            ['plan_id' => '499.92', 'description' => '500MB - 7 days (Direct Data)', 'price' => 484.92, 'validity' => '7 days', 'data_size' => '500 MB'],
            ['plan_id' => '799.91', 'description' => '1GB - 7 days (Direct Data)', 'price' => 775.91, 'validity' => '7 days', 'data_size' => '1 GB'],
            ['plan_id' => '999.92', 'description' => '1.5GB - 7 days (Direct Data)', 'price' => 969.92, 'validity' => '7 days', 'data_size' => '1.5 GB'],
            ['plan_id' => '1499.92', 'description' => '3.5GB - 7 days (Direct Data)', 'price' => 1454.92, 'validity' => '7 days', 'data_size' => '3.5 GB'],
            ['plan_id' => '2499.91', 'description' => '6GB - 7 days (Direct Data)', 'price' => 2424.91, 'validity' => '7 days', 'data_size' => '6 GB'],
            ['plan_id' => '2999.91', 'description' => '10GB - 7 days (Direct Data)', 'price' => 2909.91, 'validity' => '7 days', 'data_size' => '10 GB'],
            ['plan_id' => '4999.91', 'description' => '18GB - 7 days (Direct Data)', 'price' => 4849.91, 'validity' => '7 days', 'data_size' => '18 GB'],
            ['plan_id' => '1499.93', 'description' => '2GB - 30 days (Direct Data)', 'price' => 1454.93, 'validity' => '30 days', 'data_size' => '2 GB'],
            ['plan_id' => '1999.91', 'description' => '3GB - 30 days (Direct Data)', 'price' => 1939.91, 'validity' => '30 days', 'data_size' => '3 GB'],
            ['plan_id' => '2499.92', 'description' => '4GB - 30 days (Direct Data)', 'price' => 2424.92, 'validity' => '30 days', 'data_size' => '4 GB'],
            ['plan_id' => '2999.92', 'description' => '8GB - 30 days (Direct Data)', 'price' => 2909.92, 'validity' => '30 days', 'data_size' => '8 GB'],
            ['plan_id' => '3999.91', 'description' => '10GB - 30 days (Direct Data)', 'price' => 3879.91, 'validity' => '30 days', 'data_size' => '10 GB'],
            ['plan_id' => '4999.92', 'description' => '13GB - 30 days (Direct Data)', 'price' => 4849.92, 'validity' => '30 days', 'data_size' => '13 GB'],
            ['plan_id' => '5999.91', 'description' => '18GB - 30 days (Direct Data)', 'price' => 5819.91, 'validity' => '30 days', 'data_size' => '18 GB'],
            ['plan_id' => '7999.91', 'description' => '25GB - 30 days (Direct Data)', 'price' => 7759.91, 'validity' => '30 days', 'data_size' => '25 GB'],
            ['plan_id' => '9999.91', 'description' => '35GB - 30 days (Direct Data)', 'price' => 9699.91, 'validity' => '30 days', 'data_size' => '35 GB'],
            ['plan_id' => '14999.91', 'description' => '60GB - 30 days (Direct Data)', 'price' => 14549.91, 'validity' => '30 days', 'data_size' => '60 GB'],
            ['plan_id' => '19999.91', 'description' => '100GB - 30 days (Direct Data)', 'price' => 19399.91, 'validity' => '30 days', 'data_size' => '100 GB'],
            ['plan_id' => '29999.91', 'description' => '160GB - 30 days (Direct Data)', 'price' => 29099.91, 'validity' => '30 days', 'data_size' => '160 GB'],
            ['plan_id' => '39999.91', 'description' => '210GB - 30 days (Direct Data)', 'price' => 38799.91, 'validity' => '30 days', 'data_size' => '210 GB'],
            ['plan_id' => '49999.91', 'description' => '300GB - 90 days (Direct Data)', 'price' => 48499.91, 'validity' => '90 days', 'data_size' => '300 GB'],
            ['plan_id' => '59999.91', 'description' => '350GB - 90 days (Direct Data)', 'price' => 58199.91, 'validity' => '90 days', 'data_size' => '350 GB'],
        ];

        // Glo Data Plans
        $gloPlans = [
            ['plan_id' => '200', 'description' => '200 MB - 14 days (SME)', 'price' => 94.00, 'validity' => '14 days', 'data_size' => '200 MB'],
            ['plan_id' => '500', 'description' => '500 MB - 7 days (SME)', 'price' => 235.00, 'validity' => '7 days', 'data_size' => '500 MB'],
            ['plan_id' => '1000.11', 'description' => '1 GB - 3 days (SME)', 'price' => 282.00, 'validity' => '3 days', 'data_size' => '1 GB'],
            ['plan_id' => '3000.11', 'description' => '3 GB - 3 days (SME)', 'price' => 846.00, 'validity' => '3 days', 'data_size' => '3 GB'],
            ['plan_id' => '5000.11', 'description' => '5 GB - 3 days (SME)', 'price' => 1410.00, 'validity' => '3 days', 'data_size' => '5 GB'],
            ['plan_id' => '1000.12', 'description' => '1 GB - 7 days (SME)', 'price' => 329.00, 'validity' => '7 days', 'data_size' => '1 GB'],
            ['plan_id' => '3000.12', 'description' => '3 GB - 7 days (SME)', 'price' => 987.00, 'validity' => '7 days', 'data_size' => '3 GB'],
            ['plan_id' => '5000.12', 'description' => '5 GB - 7 days (SME)', 'price' => 1645.00, 'validity' => '7 days', 'data_size' => '5 GB'],
            ['plan_id' => '1000.21', 'description' => '1 GB - 14 days Night Plan (SME)', 'price' => 329.00, 'validity' => '14 days', 'data_size' => '1 GB'],
            ['plan_id' => '3000.21', 'description' => '3 GB - 14 days Night Plan (SME)', 'price' => 987.00, 'validity' => '14 days', 'data_size' => '3 GB'],
            ['plan_id' => '5000.21', 'description' => '5 GB - 14 days Night Plan (SME)', 'price' => 1645.00, 'validity' => '14 days', 'data_size' => '5 GB'],
            ['plan_id' => '10000.21', 'description' => '10 GB - 14 days Night Plan (SME)', 'price' => 3290.00, 'validity' => '14 days', 'data_size' => '10 GB'],
            ['plan_id' => '1000', 'description' => '1 GB - 30 days (SME)', 'price' => 470.00, 'validity' => '30 days', 'data_size' => '1 GB'],
            ['plan_id' => '2000', 'description' => '2 GB - 30 days (SME)', 'price' => 940.00, 'validity' => '30 days', 'data_size' => '2 GB'],
            ['plan_id' => '3000', 'description' => '3 GB - 30 days (SME)', 'price' => 1410.00, 'validity' => '30 days', 'data_size' => '3 GB'],
            ['plan_id' => '5000', 'description' => '5 GB - 30 days (SME)', 'price' => 2350.00, 'validity' => '30 days', 'data_size' => '5 GB'],
            ['plan_id' => '10000', 'description' => '10 GB - 30 days (SME)', 'price' => 4700.00, 'validity' => '30 days', 'data_size' => '10 GB'],
            ['plan_id' => '100.01', 'description' => '125MB - 1 day (Awoof Data)', 'price' => 95.50, 'validity' => '1 day', 'data_size' => '125 MB'],
            ['plan_id' => '200.01', 'description' => '260MB - 2 day (Awoof Data)', 'price' => 191.00, 'validity' => '2 days', 'data_size' => '260 MB'],
            ['plan_id' => '500.01', 'description' => '1.5GB - 14 days (Direct Data)', 'price' => 477.50, 'validity' => '14 days', 'data_size' => '1.5 GB'],
            ['plan_id' => '1000.01', 'description' => '2.6GB - 30 days (Direct Data)', 'price' => 955.00, 'validity' => '30 days', 'data_size' => '2.6 GB'],
            ['plan_id' => '1500.01', 'description' => '5GB - 30 days (Direct Data)', 'price' => 1432.50, 'validity' => '30 days', 'data_size' => '5 GB'],
            ['plan_id' => '2000.01', 'description' => '6.15GB - 30 days (Direct Data)', 'price' => 1910.00, 'validity' => '30 days', 'data_size' => '6.15 GB'],
            ['plan_id' => '2500.01', 'description' => '7.5GB - 30 days (Direct Data)', 'price' => 2387.50, 'validity' => '30 days', 'data_size' => '7.5 GB'],
            ['plan_id' => '3000.01', 'description' => '10GB - 30 days (Direct Data)', 'price' => 2865.00, 'validity' => '30 days', 'data_size' => '10 GB'],
            ['plan_id' => '4000.01', 'description' => '12.5GB - 30 days (Direct Data)', 'price' => 3820.00, 'validity' => '30 days', 'data_size' => '12.5 GB'],
            ['plan_id' => '5000.01', 'description' => '16GB - 30 days (Direct Data)', 'price' => 4775.00, 'validity' => '30 days', 'data_size' => '16 GB'],
            ['plan_id' => '8000.01', 'description' => '28GB - 30 days (Direct Data)', 'price' => 7640.00, 'validity' => '30 days', 'data_size' => '28 GB'],
            ['plan_id' => '10000.01', 'description' => '38GB - 30 days (Direct Data)', 'price' => 9550.00, 'validity' => '30 days', 'data_size' => '38 GB'],
            ['plan_id' => '15000.01', 'description' => '64GB - 30 days (Direct Data)', 'price' => 14325.00, 'validity' => '30 days', 'data_size' => '64 GB'],
            ['plan_id' => '20000.01', 'description' => '107GB - 30 days (Direct Data)', 'price' => 19100.00, 'validity' => '30 days', 'data_size' => '107 GB'],
            ['plan_id' => '500.02', 'description' => '2GB - 1 day (Awoof Data)', 'price' => 477.50, 'validity' => '1 day', 'data_size' => '2 GB'],
            ['plan_id' => '1500.02', 'description' => '6GB - 7 days (Direct Data)', 'price' => 1432.50, 'validity' => '7 days', 'data_size' => '6 GB'],
            ['plan_id' => '500.03', 'description' => '2.5GB - Weekend Plan - [Sat & Sun] (Awoof Data)', 'price' => 477.50, 'validity' => '2 days', 'data_size' => '2.5 GB'],
            ['plan_id' => '200.02', 'description' => '875MB - Weekend Plan [Sun] (Awoof Data)', 'price' => 191.00, 'validity' => '1 day', 'data_size' => '875 MB'],
            ['plan_id' => '30000.01', 'description' => '165GB - 30 days (Direct Data)', 'price' => 28650.00, 'validity' => '30 days', 'data_size' => '165 GB'],
            ['plan_id' => '36000.01', 'description' => '220GB - 30 days (Direct Data)', 'price' => 38200.00, 'validity' => '30 days', 'data_size' => '220 GB'],
            ['plan_id' => '50000.01', 'description' => '320GB - 30 days (Direct Data)', 'price' => 47750.00, 'validity' => '30 days', 'data_size' => '320 GB'],
            ['plan_id' => '60000.01', 'description' => '380GB - 30 days (Direct Data)', 'price' => 57300.00, 'validity' => '30 days', 'data_size' => '380 GB'],
            ['plan_id' => '75000.01', 'description' => '475GB - 30 days (Direct Data)', 'price' => 71625.00, 'validity' => '30 days', 'data_size' => '475 GB'],
            ['plan_id' => '150000.03', 'description' => '1TB (1000GB) - 365 days (Direct Data)', 'price' => 143250.00, 'validity' => '365 days', 'data_size' => '1000 GB'],
        ];

        // 9mobile Data Plans
        $nineMobilePlans = [
            ['plan_id' => '50', 'description' => '50 MB - 30 days (SME)', 'price' => 23.00, 'validity' => '30 days', 'data_size' => '50 MB'],
            ['plan_id' => '100', 'description' => '100 MB - 30 days (SME)', 'price' => 46.00, 'validity' => '30 days', 'data_size' => '100 MB'],
            ['plan_id' => '300', 'description' => '300 MB - 30 days (SME)', 'price' => 138.00, 'validity' => '30 days', 'data_size' => '300 MB'],
            ['plan_id' => '500', 'description' => '500 MB - 30 days (SME)', 'price' => 225.00, 'validity' => '30 days', 'data_size' => '500 MB'],
            ['plan_id' => '1000', 'description' => '1 GB - 30 days (SME)', 'price' => 450.00, 'validity' => '30 days', 'data_size' => '1 GB'],
            ['plan_id' => '2000', 'description' => '2 GB - 30 days (SME)', 'price' => 900.00, 'validity' => '30 days', 'data_size' => '2 GB'],
            ['plan_id' => '3000', 'description' => '3 GB - 30 days (SME)', 'price' => 1350.00, 'validity' => '30 days', 'data_size' => '3 GB'],
            ['plan_id' => '4000', 'description' => '4 GB - 30 days (SME)', 'price' => 1800.00, 'validity' => '30 days', 'data_size' => '4 GB'],
            ['plan_id' => '5000', 'description' => '5 GB - 30 days (SME)', 'price' => 2250.00, 'validity' => '30 days', 'data_size' => '5 GB'],
            ['plan_id' => '10000', 'description' => '10 GB - 30 days (SME)', 'price' => 4500.00, 'validity' => '30 days', 'data_size' => '10 GB'],
            ['plan_id' => '15000', 'description' => '15 GB - 30 days (SME)', 'price' => 6750.00, 'validity' => '30 days', 'data_size' => '15 GB'],
            ['plan_id' => '20000', 'description' => '20 GB - 30 days (SME)', 'price' => 9000.00, 'validity' => '30 days', 'data_size' => '20 GB'],
            ['plan_id' => '25000', 'description' => '25 GB - 30 days (SME)', 'price' => 11250.00, 'validity' => '30 days', 'data_size' => '25 GB'],
            ['plan_id' => '100.01', 'description' => '100MB - 1 day (Awoof Data)', 'price' => 93.00, 'validity' => '1 day', 'data_size' => '100 MB'],
            ['plan_id' => '150.01', 'description' => '180MB - 1 days (Awoof Data)', 'price' => 139.50, 'validity' => '1 day', 'data_size' => '180 MB'],
            ['plan_id' => '200.01', 'description' => '250MB - 1 days (Awoof Data)', 'price' => 186.00, 'validity' => '1 day', 'data_size' => '250 MB'],
            ['plan_id' => '350.01', 'description' => '450MB - 1 day (Awoof Data)', 'price' => 325.50, 'validity' => '1 day', 'data_size' => '450 MB'],
            ['plan_id' => '500.01', 'description' => '650MB - 3 days (Awoof Data)', 'price' => 465.00, 'validity' => '3 days', 'data_size' => '650 MB'],
            ['plan_id' => '1500.01', 'description' => '1.75GB - 7 days (Direct Data)', 'price' => 1395.00, 'validity' => '7 days', 'data_size' => '1.75 GB'],
            ['plan_id' => '600.01', 'description' => '650MB - 14 days (Direct Data)', 'price' => 558.00, 'validity' => '14 days', 'data_size' => '650 MB'],
            ['plan_id' => '1000.01', 'description' => '1.1GB - 30 days (Direct Data)', 'price' => 930.00, 'validity' => '30 days', 'data_size' => '1.1 GB'],
            ['plan_id' => '1200.01', 'description' => '1.4GB - 30 days (Direct Data)', 'price' => 1116.00, 'validity' => '30 days', 'data_size' => '1.4 GB'],
            ['plan_id' => '2000.01', 'description' => '2.44GB - 30 days (Direct Data)', 'price' => 1860.00, 'validity' => '30 days', 'data_size' => '2.44 GB'],
            ['plan_id' => '2500.01', 'description' => '3.17GB - 30 days (Direct Data)', 'price' => 2325.00, 'validity' => '30 days', 'data_size' => '3.17 GB'],
            ['plan_id' => '3000.01', 'description' => '3.91GB - 30 days (Direct Data)', 'price' => 2790.00, 'validity' => '30 days', 'data_size' => '3.91 GB'],
            ['plan_id' => '4000.01', 'description' => '5.10GB - 30 days (Direct Data)', 'price' => 3720.00, 'validity' => '30 days', 'data_size' => '5.10 GB'],
            ['plan_id' => '5000.01', 'description' => '6.5GB - 30 days (Direct Data)', 'price' => 4650.00, 'validity' => '30 days', 'data_size' => '6.5 GB'],
            ['plan_id' => '12000.01', 'description' => '16GB - 30 days (Direct Data)', 'price' => 11160.00, 'validity' => '30 days', 'data_size' => '16 GB'],
            ['plan_id' => '18500.01', 'description' => '24.3GB - 30 days (Direct Data)', 'price' => 17205.00, 'validity' => '30 days', 'data_size' => '24.3 GB'],
            ['plan_id' => '20000.01', 'description' => '26.5GB - 30 days (Direct Data)', 'price' => 18600.00, 'validity' => '30 days', 'data_size' => '26.5 GB'],
            ['plan_id' => '30000.01', 'description' => '39GB - 60 days (Direct Data)', 'price' => 27900.00, 'validity' => '60 days', 'data_size' => '39 GB'],
            ['plan_id' => '60000.01', 'description' => '78GB - 90 days (Direct Data)', 'price' => 55800.00, 'validity' => '90 days', 'data_size' => '78 GB'],
            ['plan_id' => '150000.01', 'description' => '190GB - 180 days (Direct Data)', 'price' => 139500.00, 'validity' => '180 days', 'data_size' => '190 GB'],
        ];

        // Insert all plans
        $this->insertPlans('01', $networks['01'], $mtnPlans, $now);
        $this->insertPlans('04', $networks['04'], $airtelPlans, $now);
        $this->insertPlans('02', $networks['02'], $gloPlans, $now);
        $this->insertPlans('03', $networks['03'], $nineMobilePlans, $now);

        $this->command->info('Data plans seeded successfully!');
        $this->command->info('Total MTN plans: ' . count($mtnPlans));
        $this->command->info('Total Airtel plans: ' . count($airtelPlans));
        $this->command->info('Total Glo plans: ' . count($gloPlans));
        $this->command->info('Total 9mobile plans: ' . count($nineMobilePlans));
    }

    /**
     * Insert plans for a specific network
     */
    private function insertPlans(string $networkCode, array $networkInfo, array $plans, Carbon $timestamp): void
    {
        $data = [];

        foreach ($plans as $plan) {
            $data[] = [
                'provider' => 'clubkonnect',
                'name' => $plan['description'],
                'type' => 'data',
                'network_code' => $networkCode,
                'provider_network_code' => $networkInfo['provider_code'],
                'network_name' => $networkInfo['name'],
                'plan_code' => $plan['plan_id'], // Same as provider_plan_id but for internal use
                'provider_plan_id' => $plan['plan_id'],
                'description' => $plan['description'],
                'price' => $plan['price'],
                'discounted_price' => null, // No discount initially
                'validity' => $plan['validity'],
                'data_size' => $plan['data_size'],
                'is_active' => true,
                'is_available' => true,
                'api_data' => json_encode([
                    'source' => 'clubkonnect',
                    'network_code' => $networkCode,
                    'plan_id' => $plan['plan_id'],
                    'raw_description' => $plan['description'],
                ]),
                'provider_data' => json_encode([
                    'provider' => 'clubkonnect',
                    'last_updated' => $timestamp->toDateTimeString(),
                ]),
                'created_at' => $timestamp,
                'updated_at' => $timestamp,
            ];
        }

        DB::table('products')->insert($data);
    }
}
