<?php

namespace Database\Seeders;

use App\Models\Product;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class CableTVPackagesSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Clear existing cable packages first
        Product::where('type', 'cable')->delete();

        $cablePackages = [
            // DStv Packages
            [
                'provider' => 'clubkonnect',
                'name' => 'DStv Padi',
                'type' => 'cable',
                'network_code' => 'dstv',
                'provider_network_code' => 'dstv',
                'network_name' => 'DStv',
                'plan_code' => 'dstv-padi',
                'provider_plan_id' => 'dstv-padi',
                'description' => 'DStv Padi Monthly Subscription',
                'price' => 4400.00,
                'discounted_price' => null,
                'validity' => '1 Month',
                'data_size' => null,
                'is_active' => 1,
                'is_available' => 1,
                'api_data' => json_encode(['source' => 'clubkonnect', 'package' => 'dstv-padi', 'description' => 'DStv Padi']),
                'provider_data' => json_encode(['provider' => 'clubkonnect', 'last_updated' => now()]),
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'provider' => 'clubkonnect',
                'name' => 'DStv Yanga',
                'type' => 'cable',
                'network_code' => 'dstv',
                'provider_network_code' => 'dstv',
                'network_name' => 'DStv',
                'plan_code' => 'dstv-yanga',
                'provider_plan_id' => 'dstv-yanga',
                'description' => 'DStv Yanga Monthly Subscription',
                'price' => 6000.00,
                'discounted_price' => null,
                'validity' => '1 Month',
                'data_size' => null,
                'is_active' => 1,
                'is_available' => 1,
                'api_data' => json_encode(['source' => 'clubkonnect', 'package' => 'dstv-yanga', 'description' => 'DStv Yanga']),
                'provider_data' => json_encode(['provider' => 'clubkonnect', 'last_updated' => now()]),
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'provider' => 'clubkonnect',
                'name' => 'DStv Confam',
                'type' => 'cable',
                'network_code' => 'dstv',
                'provider_network_code' => 'dstv',
                'network_name' => 'DStv',
                'plan_code' => 'dstv-confam',
                'provider_plan_id' => 'dstv-confam',
                'description' => 'DStv Confam Monthly Subscription',
                'price' => 11000.00,
                'discounted_price' => null,
                'validity' => '1 Month',
                'data_size' => null,
                'is_active' => 1,
                'is_available' => 1,
                'api_data' => json_encode(['source' => 'clubkonnect', 'package' => 'dstv-confam', 'description' => 'DStv Confam']),
                'provider_data' => json_encode(['provider' => 'clubkonnect', 'last_updated' => now()]),
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'provider' => 'clubkonnect',
                'name' => 'DStv Compact',
                'type' => 'cable',
                'network_code' => 'dstv',
                'provider_network_code' => 'dstv',
                'network_name' => 'DStv',
                'plan_code' => 'dstv79',
                'provider_plan_id' => 'dstv79',
                'description' => 'DStv Compact Monthly Subscription',
                'price' => 19000.00,
                'discounted_price' => null,
                'validity' => '1 Month',
                'data_size' => null,
                'is_active' => 1,
                'is_available' => 1,
                'api_data' => json_encode(['source' => 'clubkonnect', 'package' => 'dstv79', 'description' => 'DStv Compact']),
                'provider_data' => json_encode(['provider' => 'clubkonnect', 'last_updated' => now()]),
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'provider' => 'clubkonnect',
                'name' => 'DStv Compact Plus',
                'type' => 'cable',
                'network_code' => 'dstv',
                'provider_network_code' => 'dstv',
                'network_name' => 'DStv',
                'plan_code' => 'dstv7',
                'provider_plan_id' => 'dstv7',
                'description' => 'DStv Compact Plus Monthly Subscription',
                'price' => 30000.00,
                'discounted_price' => null,
                'validity' => '1 Month',
                'data_size' => null,
                'is_active' => 1,
                'is_available' => 1,
                'api_data' => json_encode(['source' => 'clubkonnect', 'package' => 'dstv7', 'description' => 'DStv Compact Plus']),
                'provider_data' => json_encode(['provider' => 'clubkonnect', 'last_updated' => now()]),
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'provider' => 'clubkonnect',
                'name' => 'DStv Premium',
                'type' => 'cable',
                'network_code' => 'dstv',
                'provider_network_code' => 'dstv',
                'network_name' => 'DStv',
                'plan_code' => 'dstv3',
                'provider_plan_id' => 'dstv3',
                'description' => 'DStv Premium Monthly Subscription',
                'price' => 44500.00,
                'discounted_price' => null,
                'validity' => '1 Month',
                'data_size' => null,
                'is_active' => 1,
                'is_available' => 1,
                'api_data' => json_encode(['source' => 'clubkonnect', 'package' => 'dstv3', 'description' => 'DStv Premium']),
                'provider_data' => json_encode(['provider' => 'clubkonnect', 'last_updated' => now()]),
                'created_at' => now(),
                'updated_at' => now(),
            ],

            // GOtv Packages
            [
                'provider' => 'clubkonnect',
                'name' => 'GOtv Max',
                'type' => 'cable',
                'network_code' => 'gotv',
                'provider_network_code' => 'gotv',
                'network_name' => 'GOtv',
                'plan_code' => 'gotv-max',
                'provider_plan_id' => 'gotv-max',
                'description' => 'GOtv Max Monthly Subscription',
                'price' => 8500.00,
                'discounted_price' => null,
                'validity' => '1 Month',
                'data_size' => null,
                'is_active' => 1,
                'is_available' => 1,
                'api_data' => json_encode(['source' => 'clubkonnect', 'package' => 'gotv-max', 'description' => 'GOtv Max']),
                'provider_data' => json_encode(['provider' => 'clubkonnect', 'last_updated' => now()]),
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'provider' => 'clubkonnect',
                'name' => 'GOtv Jolli',
                'type' => 'cable',
                'network_code' => 'gotv',
                'provider_network_code' => 'gotv',
                'network_name' => 'GOtv',
                'plan_code' => 'gotv-jolli',
                'provider_plan_id' => 'gotv-jolli',
                'description' => 'GOtv Jolli Monthly Subscription',
                'price' => 5800.00,
                'discounted_price' => null,
                'validity' => '1 Month',
                'data_size' => null,
                'is_active' => 1,
                'is_available' => 1,
                'api_data' => json_encode(['source' => 'clubkonnect', 'package' => 'gotv-jolli', 'description' => 'GOtv Jolli']),
                'provider_data' => json_encode(['provider' => 'clubkonnect', 'last_updated' => now()]),
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'provider' => 'clubkonnect',
                'name' => 'GOtv Jinja',
                'type' => 'cable',
                'network_code' => 'gotv',
                'provider_network_code' => 'gotv',
                'network_name' => 'GOtv',
                'plan_code' => 'gotv-jinja',
                'provider_plan_id' => 'gotv-jinja',
                'description' => 'GOtv Jinja Monthly Subscription',
                'price' => 3900.00,
                'discounted_price' => null,
                'validity' => '1 Month',
                'data_size' => null,
                'is_active' => 1,
                'is_available' => 1,
                'api_data' => json_encode(['source' => 'clubkonnect', 'package' => 'gotv-jinja', 'description' => 'GOtv Jinja']),
                'provider_data' => json_encode(['provider' => 'clubkonnect', 'last_updated' => now()]),
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'provider' => 'clubkonnect',
                'name' => 'GOtv Smallie',
                'type' => 'cable',
                'network_code' => 'gotv',
                'provider_network_code' => 'gotv',
                'network_name' => 'GOtv',
                'plan_code' => 'gotv-smallie',
                'provider_plan_id' => 'gotv-smallie',
                'description' => 'GOtv Smallie Monthly Subscription',
                'price' => 1900.00,
                'discounted_price' => null,
                'validity' => '1 Month',
                'data_size' => null,
                'is_active' => 1,
                'is_available' => 1,
                'api_data' => json_encode(['source' => 'clubkonnect', 'package' => 'gotv-smallie', 'description' => 'GOtv Smallie']),
                'provider_data' => json_encode(['provider' => 'clubkonnect', 'last_updated' => now()]),
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'provider' => 'clubkonnect',
                'name' => 'GOtv Supa',
                'type' => 'cable',
                'network_code' => 'gotv',
                'provider_network_code' => 'gotv',
                'network_name' => 'GOtv',
                'plan_code' => 'gotv-supa',
                'provider_plan_id' => 'gotv-supa',
                'description' => 'GOtv Supa Monthly Subscription',
                'price' => 11400.00,
                'discounted_price' => null,
                'validity' => '1 Month',
                'data_size' => null,
                'is_active' => 1,
                'is_available' => 1,
                'api_data' => json_encode(['source' => 'clubkonnect', 'package' => 'gotv-supa', 'description' => 'GOtv Supa']),
                'provider_data' => json_encode(['provider' => 'clubkonnect', 'last_updated' => now()]),
                'created_at' => now(),
                'updated_at' => now(),
            ],

            // StarTimes Packages
            [
                'provider' => 'clubkonnect',
                'name' => 'StarTimes Nova (Dish)',
                'type' => 'cable',
                'network_code' => 'startimes',
                'provider_network_code' => 'startimes',
                'network_name' => 'StarTimes',
                'plan_code' => 'nova',
                'provider_plan_id' => 'nova',
                'description' => 'Nova (Dish) - Monthly',
                'price' => 2100.00,
                'discounted_price' => null,
                'validity' => '1 Month',
                'data_size' => null,
                'is_active' => 1,
                'is_available' => 1,
                'api_data' => json_encode(['source' => 'clubkonnect', 'package' => 'nova', 'description' => 'Nova (Dish)']),
                'provider_data' => json_encode(['provider' => 'clubkonnect', 'last_updated' => now()]),
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'provider' => 'clubkonnect',
                'name' => 'StarTimes Basic (Antenna)',
                'type' => 'cable',
                'network_code' => 'startimes',
                'provider_network_code' => 'startimes',
                'network_name' => 'StarTimes',
                'plan_code' => 'basic',
                'provider_plan_id' => 'basic',
                'description' => 'Basic (Antenna) - Monthly',
                'price' => 4000.00,
                'discounted_price' => null,
                'validity' => '1 Month',
                'data_size' => null,
                'is_active' => 1,
                'is_available' => 1,
                'api_data' => json_encode(['source' => 'clubkonnect', 'package' => 'basic', 'description' => 'Basic (Antenna)']),
                'provider_data' => json_encode(['provider' => 'clubkonnect', 'last_updated' => now()]),
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'provider' => 'clubkonnect',
                'name' => 'StarTimes Basic (Dish)',
                'type' => 'cable',
                'network_code' => 'startimes',
                'provider_network_code' => 'startimes',
                'network_name' => 'StarTimes',
                'plan_code' => 'smart',
                'provider_plan_id' => 'smart',
                'description' => 'Basic (Dish) - Monthly',
                'price' => 5100.00,
                'discounted_price' => null,
                'validity' => '1 Month',
                'data_size' => null,
                'is_active' => 1,
                'is_available' => 1,
                'api_data' => json_encode(['source' => 'clubkonnect', 'package' => 'smart', 'description' => 'Basic (Dish)']),
                'provider_data' => json_encode(['provider' => 'clubkonnect', 'last_updated' => now()]),
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'provider' => 'clubkonnect',
                'name' => 'StarTimes Classic (Antenna)',
                'type' => 'cable',
                'network_code' => 'startimes',
                'provider_network_code' => 'startimes',
                'network_name' => 'StarTimes',
                'plan_code' => 'classic',
                'provider_plan_id' => 'classic',
                'description' => 'Classic (Antenna) - Monthly',
                'price' => 6000.00,
                'discounted_price' => null,
                'validity' => '1 Month',
                'data_size' => null,
                'is_active' => 1,
                'is_available' => 1,
                'api_data' => json_encode(['source' => 'clubkonnect', 'package' => 'classic', 'description' => 'Classic (Antenna)']),
                'provider_data' => json_encode(['provider' => 'clubkonnect', 'last_updated' => now()]),
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'provider' => 'clubkonnect',
                'name' => 'StarTimes Super (Dish)',
                'type' => 'cable',
                'network_code' => 'startimes',
                'provider_network_code' => 'startimes',
                'network_name' => 'StarTimes',
                'plan_code' => 'super',
                'provider_plan_id' => 'super',
                'description' => 'Super (Dish) - Monthly',
                'price' => 9800.00,
                'discounted_price' => null,
                'validity' => '1 Month',
                'data_size' => null,
                'is_active' => 1,
                'is_available' => 1,
                'api_data' => json_encode(['source' => 'clubkonnect', 'package' => 'super', 'description' => 'Super (Dish)']),
                'provider_data' => json_encode(['provider' => 'clubkonnect', 'last_updated' => now()]),
                'created_at' => now(),
                'updated_at' => now(),
            ],

            // Showmax Packages
            [
                'provider' => 'clubkonnect',
                'name' => 'Showmax Full',
                'type' => 'cable',
                'network_code' => 'showmax',
                'provider_network_code' => 'showmax',
                'network_name' => 'Showmax',
                'plan_code' => 'full',
                'provider_plan_id' => 'full',
                'description' => 'Showmax Full Monthly Subscription',
                'price' => 4500.00,
                'discounted_price' => null,
                'validity' => '1 Month',
                'data_size' => null,
                'is_active' => 1,
                'is_available' => 1,
                'api_data' => json_encode(['source' => 'clubkonnect', 'package' => 'full', 'description' => 'Showmax Full']),
                'provider_data' => json_encode(['provider' => 'clubkonnect', 'last_updated' => now()]),
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'provider' => 'clubkonnect',
                'name' => 'Showmax Mobile Only',
                'type' => 'cable',
                'network_code' => 'showmax',
                'provider_network_code' => 'showmax',
                'network_name' => 'Showmax',
                'plan_code' => 'mobile_only',
                'provider_plan_id' => 'mobile_only',
                'description' => 'Showmax Mobile Only Monthly Subscription',
                'price' => 2000.00,
                'discounted_price' => null,
                'validity' => '1 Month',
                'data_size' => null,
                'is_active' => 1,
                'is_available' => 1,
                'api_data' => json_encode(['source' => 'clubkonnect', 'package' => 'mobile_only', 'description' => 'Showmax Mobile Only']),
                'provider_data' => json_encode(['provider' => 'clubkonnect', 'last_updated' => now()]),
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'provider' => 'clubkonnect',
                'name' => 'Showmax Full Sports Mobile Only',
                'type' => 'cable',
                'network_code' => 'showmax',
                'provider_network_code' => 'showmax',
                'network_name' => 'Showmax',
                'plan_code' => 'full_sports_mobile_only',
                'provider_plan_id' => 'full_sports_mobile_only',
                'description' => 'Showmax Full Sports Mobile Only Monthly Subscription',
                'price' => 6500.00,
                'discounted_price' => null,
                'validity' => '1 Month',
                'data_size' => null,
                'is_active' => 1,
                'is_available' => 1,
                'api_data' => json_encode(['source' => 'clubkonnect', 'package' => 'full_sports_mobile_only', 'description' => 'Showmax Full Sports Mobile Only']),
                'provider_data' => json_encode(['provider' => 'clubkonnect', 'last_updated' => now()]),
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'provider' => 'clubkonnect',
                'name' => 'Showmax Sports Only',
                'type' => 'cable',
                'network_code' => 'showmax',
                'provider_network_code' => 'showmax',
                'network_name' => 'Showmax',
                'plan_code' => 'sports-only-1',
                'provider_plan_id' => 'sports-only-1',
                'description' => 'Showmax Sports Only Monthly Subscription',
                'price' => 3600.00,
                'discounted_price' => null,
                'validity' => '1 Month',
                'data_size' => null,
                'is_active' => 1,
                'is_available' => 1,
                'api_data' => json_encode(['source' => 'clubkonnect', 'package' => 'sports-only-1', 'description' => 'Showmax Sports Only']),
                'provider_data' => json_encode(['provider' => 'clubkonnect', 'last_updated' => now()]),
                'created_at' => now(),
                'updated_at' => now(),
            ],
        ];

        // Insert all packages
        foreach ($cablePackages as $package) {
            Product::updateOrCreate(
                [
                    'provider' => $package['provider'],
                    'provider_plan_id' => $package['provider_plan_id'],
                    'network_code' => $package['network_code'],
                    'type' => 'cable'
                ],
                $package
            );
        }

        $this->command->info('✅ Cable TV packages seeded successfully! Total: ' . count($cablePackages));
    }
}
