<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('products', function (Blueprint $table) {
            // Add columns for better ClubKonnect integration
            $table->string('provider')->default('clubkonnect')->after('id');
            $table->string('provider_plan_id')->nullable()->after('plan_code');
            $table->string('provider_network_code')->nullable()->after('network_code');
            $table->json('provider_data')->nullable()->after('api_data');
            $table->boolean('is_available')->default(true)->after('is_active');

            // Add indexes
            $table->index(['provider', 'type']);
            $table->index(['provider', 'network_code']);
            $table->index('provider_plan_id');
            $table->unique(['provider', 'provider_plan_id', 'network_code']);
        });
    }

    public function down(): void
    {
        Schema::table('products', function (Blueprint $table) {
            $table->dropColumn(['provider', 'provider_plan_id', 'provider_network_code', 'provider_data', 'is_available']);
            $table->dropIndex(['provider', 'type']);
            $table->dropIndex(['provider', 'network_code']);
            $table->dropIndex('provider_plan_id');
            $table->dropUnique(['provider', 'provider_plan_id', 'network_code']);
        });
    }
};
