<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create(
            'transactions',
            function (Blueprint $table) {
                $table->id();
                $table->foreignId('user_id')->constrained()->onDelete('cascade');
                $table->string('reference')->unique();
                $table->string('type'); // airtime, data, electricity, cable, deposit, withdrawal
                $table->string('status')->default('pending'); // pending, processing, completed, failed
                $table->decimal('amount', 10, 2);
                $table->decimal('amount_charged', 10, 2)->nullable(); // Amount after discount
                $table->string('network')->nullable();
                $table->string('phone')->nullable();
                $table->string('plan_code')->nullable();
                $table->string('plan_description')->nullable();
                $table->string('order_id')->nullable(); // ClubKonnect order ID
                $table->string('request_id')->nullable(); // ClubKonnect request ID
                $table->json('api_response')->nullable();
                $table->text('remark')->nullable();
                $table->timestamps();

                $table->index(['user_id', 'status']);
                $table->index('reference');
                $table->index('order_id');
            }
        );
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('transactions');
    }
};
