<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create(
            'networks',
            function (Blueprint $table) {
                $table->id();
                $table->string('code')->unique(); // 01, 02, 03, 04
                $table->string('name'); // MTN, GLO, Airtel, 9mobile
                $table->string('logo')->nullable();
                $table->decimal('airtime_discount', 5, 2)->default(0); // 3.00, 8.00, etc.
                $table->boolean('is_active')->default(true);
                $table->timestamps();
            }
        );
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('networks');
    }
};
