<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // database/migrations/xxxx_create_products_table.php
        Schema::create('products', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('type'); // airtime, data, electricity, cable
            $table->string('network_code'); // 01, 02, 03, 04
            $table->string('network_name'); // MTN, GLO, etc.
            $table->string('plan_code')->nullable(); // For data plans
            $table->string('description');
            $table->decimal('price', 10, 2);
            $table->decimal('discounted_price', 10, 2)->nullable();
            $table->string('validity')->nullable(); // For data plans
            $table->string('data_size')->nullable(); // For data plans
            $table->boolean('is_active')->default(true);
            $table->json('api_data')->nullable(); // Store raw API response
            $table->timestamps();

            $table->index(['type', 'network_code']);
            $table->index('plan_code');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('products');
    }
};
