<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Third Party Services
    |--------------------------------------------------------------------------
    |
    | This file is for storing the credentials for third party services such
    | as Mailgun, Postmark, AWS and more. This file provides the de facto
    | location for this type of information, allowing packages to have
    | a conventional file to locate the various service credentials.
    |
    */

    'postmark' => [
        'key' => env('POSTMARK_API_KEY'),
    ],

    'resend' => [
        'key' => env('RESEND_API_KEY'),
    ],

    'ses' => [
        'key' => env('AWS_ACCESS_KEY_ID'),
        'secret' => env('AWS_SECRET_ACCESS_KEY'),
        'region' => env('AWS_DEFAULT_REGION', 'us-east-1'),
    ],

    'slack' => [
        'notifications' => [
            'bot_user_oauth_token' => env('SLACK_BOT_USER_OAUTH_TOKEN'),
            'channel' => env('SLACK_BOT_USER_DEFAULT_CHANNEL'),
        ],
    ],

    'monnify' => [
        'base_url' => env('MONNIFY_BASE_URL', 'https://sandbox.monnify.com'),
        'api_key' => env('MONNIFY_API_KEY'),
        'secret_key' => env('MONNIFY_SECRET_KEY'),
        'contract_code' => env('MONNIFY_CONTRACT_CODE'),
        'wallet_account_number' => env('MONNIFY_WALLET_ACCOUNT_NUMBER', ''),
    ],

    'clubkonnect' => [
        'user_id' => env('CLUBKONNECT_USER_ID'),
        'api_key' => env('CLUBKONNECT_API_KEY'),
        'short_code' => env('CLUBKONNECT_SHORT_CODE'),
        'api_url' => 'https://www.nellobytesystems.com/APIDatabundleV1.asp',
        'test_mode' => env('CLUBKONNECT_TEST_MODE', false),
    ],

    'company' => [
        'bank_account_number' => env('COMPANY_BANK_ACCOUNT_NUMBER'),
        'bank_name' => env('COMPANY_BANK_NAME'),
        'account_name' => env('COMPANY_BANK_ACCOUNT_NAME'),
        'transfer_notes' => env('COMPANY_BANK_TRANSFER_NOTES'),
    ],

];
