<?php

namespace App\Traits;

use App\Models\UserMessage;

trait HandlesSystemAnnouncements
{
    /**
     * Create a system-wide announcement
     */
    public function createSystemAnnouncement($title, $message, $type = 'info', $expiresIn = null, $actions = null)
    {
        return UserMessage::create([
            'user_id' => null, // Null means it's a system announcement
            'title' => $title,
            'message' => $message,
            'type' => $type,
            'expires_at' => $expiresIn ? now()->add($expiresIn) : now()->addDays(30),
            'actions' => $actions,
        ]);
    }

    /**
     * Get active system announcements
     */
    public function getActiveAnnouncements()
    {
        return UserMessage::whereNull('user_id')
            ->where('expires_at', '>', now())
            ->orderBy('created_at', 'desc')
            ->get();
    }

    /**
     * Send announcement to specific users
     */
    public function sendAnnouncementToUsers($userIds, $title, $message, $type = 'info', $expiresIn = null, $actions = null)
    {
        foreach ($userIds as $userId) {
            UserMessage::create([
                'user_id' => $userId,
                'title' => $title,
                'message' => $message,
                'type' => $type,
                'expires_at' => $expiresIn ? now()->add($expiresIn) : now()->addDays(7),
                'actions' => $actions,
            ]);
        }
    }

    /**
     * Send announcement to all users
     */
    public function broadcastAnnouncement($title, $message, $type = 'info', $expiresIn = null, $actions = null)
    {
        // Create as system announcement
        $announcement = $this->createSystemAnnouncement($title, $message, $type, $expiresIn, $actions);

        // Clear previous user assignments (if you want to re-send to all)
        $announcement->users()->detach();

        return $announcement;
    }
}
