<?php

namespace App\Services;

use App\Models\WalletHistory;

class WalletHistoryService
{
    public static function log(array $data): WalletHistory
    {
        return WalletHistory::create([
            'user_id' => $data['user_id'],
            'reference' => $data['reference'],
            'type' => $data['type'],
            'direction' => $data['direction'],
            'amount' => $data['amount'],
            'balance_before' => $data['balance_before'],
            'balance_after' => $data['balance_after'],
            'source' => $data['source'],
            'description' => $data['description'] ?? null,
            'status' => $data['status'] ?? 'success',
            'meta' => $data['meta'] ?? null,
        ]);
    }
}
