<?php
// app/Providers/SettingsServiceProvider.php
namespace App\Providers;

use App\Models\Setting;
use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\Schema;

class SettingsServiceProvider extends ServiceProvider
{
    public function register(): void
    {
        //
    }

    public function boot(): void
    {
        // Only load settings if table exists
        if (!$this->app->runningInConsole() && Schema::hasTable('settings')) {
            $this->loadSettings();
        }
    }

    protected function loadSettings(): void
    {
        if (!Schema::hasTable('settings')) {
            return;
        }

        try {
            $settings = Cache::remember('app_settings', 3600, function () {
                return Setting::all()->mapWithKeys(function ($setting) {
                    $value = $setting->is_encrypted ? $setting->getDecryptedValue() : $setting->value;
                    return [$setting->key => Setting::castValue($value, $setting->type)];
                })->toArray();
            });

            foreach ($settings as $key => $value) {
                config([$key => $value]);
            }
        } catch (\Exception $e) {
            \Log::error('Failed to load settings: ' . $e->getMessage());
        }
    }
}