<?php

use App\Models\Setting;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Storage;

public function boot()
{
// Serve dynamic favicon
Route::get('/dynamic-favicon.ico', function () {
$favicon = Setting::where('key', 'branding.favicon')->first();
$faviconSvg = Setting::where('key', 'branding.favicon_svg')->first();

// Check for SVG code first
if ($faviconSvg && $faviconSvg->value) {
return response($faviconSvg->value)
->header('Content-Type', 'image/svg+xml')
->header('Cache-Control', 'public, max-age=86400');
}

// Check for uploaded file
if ($favicon && $favicon->file_path) {
$path = storage_path('app/public/' . $favicon->file_path);
if (file_exists($path)) {
$ext = pathinfo($path, PATHINFO_EXTENSION);
$mime = match(strtolower($ext)) {
'ico' => 'image/x-icon',
'svg' => 'image/svg+xml',
'png' => 'image/png',
default => 'application/octet-stream',
};

return response()->file($path, [
'Content-Type' => $mime,
'Cache-Control' => 'public, max-age=86400',
]);
}
}

// Fallback to default
return response()->file(public_path('favicon.ico'));
})->name('dynamic.favicon');

// Serve dynamic logo
Route::get('/dynamic-logo.{ext?}', function ($ext = 'svg') {
$logo = Setting::where('key', 'branding.logo')->first();
$logoSvg = Setting::where('key', 'branding.logo_svg')->first();

// Check for SVG code first
if ($logoSvg && $logoSvg->value) {
return response($logoSvg->value)
->header('Content-Type', 'image/svg+xml')
->header('Cache-Control', 'public, max-age=86400');
}

// Check for uploaded file
if ($logo && $logo->file_path) {
$path = storage_path('app/public/' . $logo->file_path);
if (file_exists($path)) {
$ext = pathinfo($path, PATHINFO_EXTENSION);
$mime = match(strtolower($ext)) {
'svg' => 'image/svg+xml',
'png' => 'image/png',
'jpg', 'jpeg' => 'image/jpeg',
default => 'application/octet-stream',
};

return response()->file($path, [
'Content-Type' => $mime,
'Cache-Control' => 'public, max-age=86400',
]);
}
}

// Fallback to default
$defaultPath = public_path("logo.{$ext}");
if (file_exists($defaultPath)) {
return response()->file($defaultPath);
}

return response('Logo not found', 404);
})->name('dynamic.logo');
}