<?php

namespace App\Http\Requests; // ✅ Correct namespace
use App\Models\User; // ✅ Import User model
use Illuminate\Foundation\Http\FormRequest; // ✅ Correct class
use Illuminate\Validation\Rule;

class ProfileUpdateRequest extends FormRequest
{
    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\Rule|array|string>
     */
    public function rules(): array
    {
        return [
            'name' => ['required', 'string', 'max:255'],

            'nin' => [
                'nullable',
                'string',
                'size:11',
                'regex:/^[0-9]{11}$/' // ✅ Fixed regex
            ],

            'bvn' => [ // ✅ Corrected from "bwn" to "bvn"
                'nullable',
                'string',
                'size:11',
                'regex:/^[0-9]{11}$/' // ✅ Fixed regex
            ],

            'email' => [
                'required',
                'string',
                'lowercase',
                'email',
                'max:255',
                Rule::unique(User::class)->ignore($this->user()->id),
            ],
        ];
    }
}
