<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class ShareNotificationCount
{
    public function handle(Request $request, Closure $next)
    {
        if (Auth::check()) {
            $user = Auth::user();

            $unreadCount = $user->unreadMessages()->count() +
                \App\Models\UserMessage::whereNull('user_id')
                ->whereHas('users', function ($query) use ($user) {
                    $query->where('user_id', $user->id)
                        ->where('is_read', false);
                })
                ->count();

            // Share with Inertia
            if ($request->header('X-Inertia')) {
                $request->session()->flash('unread_notifications_count', $unreadCount);
            }

            // Share with all views
            view()->share('unreadNotificationsCount', $unreadCount);
        }

        return $next($request);
    }
}
