<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

class KycController extends Controller
{
    public function submitKyc(Request $request)
    {
        $request->validate([
            'bvn' => 'nullable|string|size:11',
            'nin' => 'nullable|string|size:11',
        ]);

        $user = $request->user();

        $user->update([
            'bvn' => $request->bvn,
            'nin' => $request->nin,
            'is_verified' => false,
            'kyc_status' => 'pending',
        ]);

        // Call verification API
        $verified = $this->verifyWithApi($user);

        if ($verified) {
            $user->update([
                'is_verified' => true,
                'kyc_status' => 'verified',
            ]);

            // optional virtual account creation
            // $this->createVirtualAccount($user);
        } else {
            $user->update([
                'kyc_status' => 'failed',
            ]);
        }

        return redirect()->route('dashboard');
    }

    private function verifyWithApi($user)
    {
        // fake for now, replace with real API logic
        return true;
    }
}
