<?php

namespace App\Http\Controllers;

use App\Data\UserShowData;
use App\Services\AccountService;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Inertia\Inertia;

class DashboardController extends Controller
{
    public function index(Request $request, AccountService $accountService)
    {
        $user = \App\Models\User::with('wallet')->find(Auth::id());

        if (is_null($user->wallet)) {
            $wallet = $user->wallet()->create([
                'balance' => 0,
                'currency' => 'NGN',
                'status' => 'active',
                'account_number' => $accountService->generate(),
            ]);

            $user->setRelation('wallet', $wallet);
        }

        // Get company account details SAME AS WalletController
        $companyAccountDetails = [
            'account_number' => env('COMPANY_BANK_ACCOUNT_NUMBER', '1234567890'),
            'bank_name' => env('COMPANY_BANK_NAME', 'Your Bank Name'),
            'account_name' => env('COMPANY_BANK_ACCOUNT_NAME', 'Your Company Name'),
            'notes' => env('COMPANY_BANK_TRANSFER_NOTES', 'Use your registered name/email as depositor. Funds reflect in 1-2 hours after confirmation.'),
            'active' => filter_var(env('COMPANY_BANK_ACTIVE', true), FILTER_VALIDATE_BOOLEAN),
        ];

        return Inertia::render('Dashboard', [
            // Pass the user with avatar_url appended
            'user' => $request->user()->append('avatar_url'),
            'wallet' => $user->wallet,
            // If you still need UserShowData for other purposes, rename it
            'userData' => UserShowData::from($user),
            // Add company account details (EXACT SAME as WalletController)
            'companyAccountDetails' => $companyAccountDetails,
        ]);
    }
}
