<?php

namespace App\Filament\Widgets;

use App\Models\Wallet;
use Filament\Widgets\Widget;

class WalletSummary extends Widget
{
    protected string $view = 'filament.widgets.wallet-summary';

    protected int | string | array $columnSpan = 'full';

    public function getTotalBalance(): string
    {
        return '₦' . number_format(Wallet::sum('balance'), 2);
    }

    public function getTotalWallets(): int
    {
        return Wallet::count();
    }

    public function getAverageBalance(): string
    {
        $count = Wallet::count();
        $total = Wallet::sum('balance');

        if ($count === 0) return '₦0.00';
        return '₦' . number_format($total / $count, 2);
    }

    public function getTopWallet(): ?Wallet
    {
        return Wallet::with('user')->orderBy('balance', 'desc')->first();
    }
}
