<?php

namespace App\Filament\Widgets;

use App\Models\User;
use App\Models\Wallet;
use App\Models\Transaction;
use Filament\Widgets\StatsOverviewWidget as BaseWidget;
use Filament\Widgets\StatsOverviewWidget\Stat;

class StatsOverview extends BaseWidget
{
    protected function getStats(): array
    {
        return [
            Stat::make('Total Users', User::count())
                ->description('Registered users')
                ->descriptionIcon('heroicon-m-user-group')
                ->color('success'),

            Stat::make('Total Balance', '₦' . number_format(Wallet::sum('balance'), 2))
                ->description('Total wallet balance')
                ->descriptionIcon('heroicon-m-currency-dollar')
                ->color('warning'),

            Stat::make('Today\'s Transactions', Transaction::whereDate('created_at', today())->count())
                ->description('Transactions today')
                ->descriptionIcon('heroicon-m-arrow-trending-up')
                ->color('info'),

            Stat::make('Success Rate', $this->getSuccessRate() . '%')
                ->description('Transaction success rate')
                ->descriptionIcon('heroicon-m-check-badge')
                ->color(fn() => $this->getSuccessRate() >= 80 ? 'success' : 'danger'),
        ];
    }

    protected function getSuccessRate(): float
    {
        $total = Transaction::count();
        $success = Transaction::where('status', 'success')->count();

        if ($total === 0) return 0;
        return round(($success / $total) * 100, 1);
    }
}
