<?php

namespace App\Filament\Widgets;

use App\Models\Transaction;  // UNCOMMENT THIS LINE
use Filament\Tables;
use Filament\Tables\Table;
use Filament\Widgets\TableWidget as BaseWidget;

class LatestTransactions extends BaseWidget
{
    protected int | string | array $columnSpan = 'full';

    public function table(Table $table): Table
    {
        return $table
            ->query(
                Transaction::query()->latest()->limit(10)
            )
            ->columns([
                Tables\Columns\TextColumn::make('reference')
                    ->label('Transaction ID')
                    ->searchable(),

                Tables\Columns\TextColumn::make('user.name')
                    ->label('Customer')
                    ->searchable(),

            Tables\Columns\TextColumn::make('type')
                ->label('Type')
                    ->badge()
                    ->color(fn(string $state): string => match ($state) {
                        'airtime' => 'success',
                        'data' => 'blue',
                        default => 'gray',
                    }),

                Tables\Columns\TextColumn::make('network')
                    ->badge()
                    ->formatStateUsing(fn($state) => match ($state) {
                        '01' => 'MTN',
                        '02' => 'GLO',
                        '03' => '9MOBILE',
                        '04' => 'AIRTEL',
                        default => $state,
                    })
                    ->color(fn(string $state): string => match ($state) {
                        '01', 'MTN' => 'yellow',
                        '02', 'GLO' => 'green',
                        '04', 'AIRTEL' => 'red',
                        '03', '9MOBILE' => 'purple',
                        default => 'gray',
                    }),

                Tables\Columns\TextColumn::make('amount')
                    ->money('NGN')
                    ->sortable(),

                Tables\Columns\TextColumn::make('status')
                    ->badge()
                    ->color(fn(string $state): string => match ($state) {
                        'success' => 'success',
                        'pending' => 'warning',
                        'failed' => 'danger',
                        default => 'gray',
                    }),

                Tables\Columns\TextColumn::make('created_at')
                    ->dateTime()
                    ->sortable(),
            ]);
    }
}
