<?php

namespace App\Filament\Resources\WalletTransactions\Schemas;

use Filament\Infolists\Components\TextEntry;
use Filament\Schemas\Schema;

class WalletTransactionInfolist
{
    public static function configure(Schema $schema): Schema
    {
        return $schema
            ->components([
                TextEntry::make('user.name')
                    ->numeric(),
                TextEntry::make('wallet.id')
                    ->numeric(),
                TextEntry::make('reference'),
                TextEntry::make('amount')
                    ->numeric(),
                TextEntry::make('type'),
                TextEntry::make('status'),
                TextEntry::make('payment_method'),
                TextEntry::make('completed_at')
                    ->dateTime(),
                TextEntry::make('created_at')
                    ->dateTime(),
                TextEntry::make('updated_at')
                    ->dateTime(),
            ]);
    }
}
