<?php

namespace App\Filament\Resources\UserMessages\Schemas;

use Filament\Forms\Components\DateTimePicker;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\Textarea;
use Filament\Forms\Components\Toggle;
use Filament\Schemas\Schema;

class UserMessageForm
{
    public static function configure(Schema $schema): Schema
    {
        return $schema
            ->components([
                TextInput::make('title')
                    ->required(),
                Textarea::make('message')
                    ->required()
                    ->columnSpanFull(),
                Select::make('type')
                    ->options(['info' => 'Info', 'success' => 'Success', 'warning' => 'Warning', 'error' => 'Error'])
                    ->default('info')
                    ->required(),
                DateTimePicker::make('expires_at'),
                Toggle::make('is_read')
                    ->required(),
                TextInput::make('user_id')
                    ->numeric()
                    ->default(null),
            ]);
    }
}
