<?php

namespace App\Filament\Resources\Transactions\Schemas;

use Filament\Infolists\Components\TextEntry;
use Filament\Schemas\Schema;

class TransactionInfolist
{
    public static function configure(Schema $schema): Schema
    {
        return $schema
            ->components([
                TextEntry::make('user_id')
                    ->numeric(),
                TextEntry::make('wallet_transaction_id')
                    ->numeric(),
                TextEntry::make('reference'),
                TextEntry::make('type'),
                TextEntry::make('service_type'),
                TextEntry::make('service_provider'),
                TextEntry::make('status'),
                TextEntry::make('amount')
                    ->numeric(),
                TextEntry::make('amount_charged')
                    ->numeric(),
                TextEntry::make('network'),
                TextEntry::make('phone'),
                TextEntry::make('plan_code'),
                TextEntry::make('plan_description'),
                TextEntry::make('order_id'),
                TextEntry::make('request_id'),
                TextEntry::make('created_at')
                    ->dateTime(),
                TextEntry::make('updated_at')
                    ->dateTime(),
            ]);
    }
}
