<?php

namespace App\Filament\Resources\Transactions\Schemas;

use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\Textarea;
use Filament\Schemas\Schema;

class TransactionForm
{
    public static function configure(Schema $schema): Schema
    {
        return $schema
            ->components([
                TextInput::make('user_id')
                    ->required()
                    ->numeric(),
                TextInput::make('wallet_transaction_id')
                    ->numeric()
                    ->default(null),
                TextInput::make('reference')
                    ->required(),
                TextInput::make('type')
                    ->default(null),
                TextInput::make('service_type')
                    ->default('airtime'),
                TextInput::make('service_provider')
                    ->default(null),
                Textarea::make('service_details')
                    ->default(null)
                    ->columnSpanFull(),
                TextInput::make('status')
                    ->required()
                    ->default('pending'),
                TextInput::make('amount')
                    ->required()
                    ->numeric(),
                TextInput::make('amount_charged')
                    ->numeric()
                    ->default(null),
                TextInput::make('network')
                    ->default(null),
                TextInput::make('phone')
                    ->tel()
                    ->default(null),
                TextInput::make('plan_code')
                    ->default(null),
                TextInput::make('plan_description')
                    ->default(null),
                TextInput::make('order_id')
                    ->default(null),
                TextInput::make('request_id')
                    ->default(null),
                Textarea::make('api_response')
                    ->default(null)
                    ->columnSpanFull(),
                Textarea::make('remark')
                    ->default(null)
                    ->columnSpanFull(),
            ]);
    }
}
