<?php

use Filament\Infolists\Components\TextEntry;
use Filament\Infolists\Components\IconEntry;
use Filament\Schemas\Schema;

class SettingInfolist
{
    public static function configure(Schema $schema): Schema
    {
        return $schema->schema([
            TextEntry::make('key')
                ->label('Key'),

            TextEntry::make('value')
                ->label('Value')
                ->limit(50),

            IconEntry::make('is_encrypted')
                ->label('Encrypted')
                ->boolean(),

            TextEntry::make('description')
                ->label('Description'),

            TextEntry::make('updated_at')
                ->label('Last Updated')
                ->dateTime(),
        ]);
    }
}
