<?php

namespace App\Filament\Resources\Settings\Schemas;

use Filament\Schemas\Schema;

class SettingForm
{
    public static function configure(Schema $schema): Schema
    {
        return $schema
            ->schema([
                $schema->textInput('key')
                    ->label('Setting Key')
                    ->required()
                    ->maxLength(255)
                    ->unique(ignorable: fn($record) => $record),

                $schema->textarea('value')
                    ->label('Setting Value')
                    ->rows(3),

                $schema->toggle('is_encrypted')
                    ->label('Encrypted?')
                    ->helperText('Enable if this setting contains sensitive data'),

                $schema->textarea('description')
                    ->label('Description')
                    ->rows(2),
            ]);
    }
}
