<?php

namespace App\Filament\Resources\Products\Schemas;

use Filament\Infolists\Components\IconEntry;
use Filament\Infolists\Components\TextEntry;
use Filament\Schemas\Schema;

class ProductInfolist
{
    public static function configure(Schema $schema): Schema
    {
        return $schema
            ->components([
                TextEntry::make('provider'),
                TextEntry::make('name'),
                TextEntry::make('type'),
                TextEntry::make('network_code'),
                TextEntry::make('provider_network_code'),
                TextEntry::make('network_name'),
                TextEntry::make('plan_code'),
                TextEntry::make('provider_plan_id'),
                TextEntry::make('description'),
                TextEntry::make('price')
                    ->money(),
                TextEntry::make('discounted_price')
                    ->numeric(),
                TextEntry::make('validity'),
                TextEntry::make('data_size'),
                IconEntry::make('is_active')
                    ->boolean(),
                IconEntry::make('is_available')
                    ->boolean(),
                TextEntry::make('created_at')
                    ->dateTime(),
                TextEntry::make('updated_at')
                    ->dateTime(),
            ]);
    }
}
