<?php

namespace App\Filament\Resources\Products\Schemas;

use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\Textarea;
use Filament\Forms\Components\Toggle;
use Filament\Schemas\Schema;

class ProductForm
{
    public static function configure(Schema $schema): Schema
    {
        return $schema
            ->components([
                TextInput::make('provider')
                    ->required()
                    ->default('clubkonnect'),
                TextInput::make('name')
                    ->required(),
                TextInput::make('type')
                    ->required(),
                TextInput::make('network_code')
                    ->required(),
                TextInput::make('provider_network_code')
                    ->default(null),
                TextInput::make('network_name')
                    ->required(),
                TextInput::make('plan_code')
                    ->default(null),
                TextInput::make('provider_plan_id')
                    ->default(null),
                TextInput::make('description')
                    ->required(),
                TextInput::make('price')
                    ->required()
                    ->numeric()
                    ->prefix('$'),
                TextInput::make('discounted_price')
                    ->numeric()
                    ->default(null),
                TextInput::make('validity')
                    ->default(null),
                TextInput::make('data_size')
                    ->default(null),
                Toggle::make('is_active')
                    ->required(),
                Toggle::make('is_available')
                    ->required(),
                Textarea::make('api_data')
                    ->default(null)
                    ->columnSpanFull(),
                Textarea::make('provider_data')
                    ->default(null)
                    ->columnSpanFull(),
            ]);
    }
}
