<?php

namespace App\Filament\Resources\ApiProviders\Tables;

use Filament\Actions\BulkActionGroup;
use Filament\Actions\DeleteBulkAction;
use Filament\Actions\EditAction;
use Filament\Actions\ViewAction;
use Filament\Tables\Columns\IconColumn;
use Filament\Tables\Columns\TextColumn;
use Filament\Tables\Table;

class ApiProvidersTable
{
    public static function configure(Table $table): Table
    {
        return $table
            ->columns([
                TextColumn::make('name')
                    ->searchable(),
                TextColumn::make('code')
                    ->searchable(),
                TextColumn::make('api_url')
                    ->searchable(),
                TextColumn::make('api_key')
                    ->searchable(),
                TextColumn::make('secret_key')
                    ->searchable(),
                TextColumn::make('balance')
                    ->numeric()
                    ->sortable(),
                TextColumn::make('success_rate')
                    ->numeric()
                    ->sortable(),
                TextColumn::make('avg_response_time')
                    ->numeric()
                    ->sortable(),
                TextColumn::make('success_count')
                    ->numeric()
                    ->sortable(),
                TextColumn::make('failure_count')
                    ->numeric()
                    ->sortable(),
                TextColumn::make('circuit_status'),
                TextColumn::make('circuit_opened_at')
                    ->dateTime()
                    ->sortable(),
                TextColumn::make('consecutive_failures')
                    ->numeric()
                    ->sortable(),
                TextColumn::make('circuit_failure_threshold')
                    ->numeric()
                    ->sortable(),
                TextColumn::make('concurrent_limit')
                    ->numeric()
                    ->sortable(),
                TextColumn::make('current_load')
                    ->numeric()
                    ->sortable(),
                IconColumn::make('is_active')
                    ->boolean(),
                TextColumn::make('priority')
                    ->numeric()
                    ->sortable(),
                TextColumn::make('last_activity_at')
                    ->dateTime()
                    ->sortable(),
                TextColumn::make('timeout_seconds')
                    ->numeric()
                    ->sortable(),
                TextColumn::make('retry_attempts')
                    ->numeric()
                    ->sortable(),
                IconColumn::make('is_default')
                    ->boolean(),
                TextColumn::make('min_amount')
                    ->numeric()
                    ->sortable(),
                TextColumn::make('max_amount')
                    ->numeric()
                    ->sortable(),
                TextColumn::make('created_at')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
                TextColumn::make('updated_at')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
            ])
            ->filters([
                //
            ])
            ->recordActions([
                ViewAction::make(),
                EditAction::make(),
            ])
            ->toolbarActions([
                BulkActionGroup::make([
                    DeleteBulkAction::make(),
                ]),
            ]);
    }
}
