<?php

namespace App\Filament\Resources\ApiProviders\Schemas;

use Filament\Infolists\Components\IconEntry;
use Filament\Infolists\Components\TextEntry;
use Filament\Schemas\Schema;

class ApiProviderInfolist
{
    public static function configure(Schema $schema): Schema
    {
        return $schema
            ->components([
                TextEntry::make('name'),
                TextEntry::make('code'),
                TextEntry::make('api_url'),
                TextEntry::make('api_key'),
                TextEntry::make('secret_key'),
                TextEntry::make('balance')
                    ->numeric(),
                TextEntry::make('success_rate')
                    ->numeric(),
                TextEntry::make('avg_response_time')
                    ->numeric(),
                TextEntry::make('success_count')
                    ->numeric(),
                TextEntry::make('failure_count')
                    ->numeric(),
                TextEntry::make('circuit_status'),
                TextEntry::make('circuit_opened_at')
                    ->dateTime(),
                TextEntry::make('consecutive_failures')
                    ->numeric(),
                TextEntry::make('circuit_failure_threshold')
                    ->numeric(),
                TextEntry::make('concurrent_limit')
                    ->numeric(),
                TextEntry::make('current_load')
                    ->numeric(),
                IconEntry::make('is_active')
                    ->boolean(),
                TextEntry::make('priority')
                    ->numeric(),
                TextEntry::make('last_activity_at')
                    ->dateTime(),
                TextEntry::make('timeout_seconds')
                    ->numeric(),
                TextEntry::make('retry_attempts')
                    ->numeric(),
                IconEntry::make('is_default')
                    ->boolean(),
                TextEntry::make('min_amount')
                    ->numeric(),
                TextEntry::make('max_amount')
                    ->numeric(),
                TextEntry::make('created_at')
                    ->dateTime(),
                TextEntry::make('updated_at')
                    ->dateTime(),
            ]);
    }
}
