<?php

namespace App\Filament\Resources\ApiProviders\Schemas;

use Filament\Forms\Components\DateTimePicker;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\Textarea;
use Filament\Forms\Components\Toggle;
use Filament\Schemas\Schema;

class ApiProviderForm
{
    public static function configure(Schema $schema): Schema
    {
        return $schema
            ->components([
                TextInput::make('name')
                    ->required(),
                TextInput::make('code')
                    ->required(),
                TextInput::make('api_url')
                    ->required(),
                TextInput::make('api_key')
                    ->default(null),
                TextInput::make('secret_key')
                    ->default(null),
                TextInput::make('balance')
                    ->required()
                    ->numeric()
                    ->default(0.0),
                TextInput::make('success_rate')
                    ->required()
                    ->numeric()
                    ->default(100.0),
                TextInput::make('avg_response_time')
                    ->required()
                    ->numeric()
                    ->default(0),
                TextInput::make('success_count')
                    ->required()
                    ->numeric()
                    ->default(0),
                TextInput::make('failure_count')
                    ->required()
                    ->numeric()
                    ->default(0),
                Select::make('circuit_status')
                    ->options(['closed' => 'Closed', 'open' => 'Open', 'half_open' => 'Half open'])
                    ->default('closed')
                    ->required(),
                DateTimePicker::make('circuit_opened_at'),
                TextInput::make('consecutive_failures')
                    ->required()
                    ->numeric()
                    ->default(0),
                TextInput::make('circuit_failure_threshold')
                    ->numeric()
                    ->default(5),
                TextInput::make('concurrent_limit')
                    ->required()
                    ->numeric()
                    ->default(10),
                TextInput::make('current_load')
                    ->required()
                    ->numeric()
                    ->default(0),
                Toggle::make('is_active')
                    ->required(),
                TextInput::make('priority')
                    ->required()
                    ->numeric()
                    ->default(1),
                Textarea::make('supported_services')
                    ->default(null)
                    ->columnSpanFull(),
                Textarea::make('supported_networks')
                    ->default(null)
                    ->columnSpanFull(),
                Textarea::make('supported_plans')
                    ->default(null)
                    ->columnSpanFull(),
                Textarea::make('rates')
                    ->default(null)
                    ->columnSpanFull(),
                Textarea::make('plan_mapping')
                    ->default(null)
                    ->columnSpanFull(),
                Textarea::make('config')
                    ->default(null)
                    ->columnSpanFull(),
                Textarea::make('service_configs')
                    ->default(null)
                    ->columnSpanFull(),
                DateTimePicker::make('last_activity_at'),
                TextInput::make('timeout_seconds')
                    ->numeric()
                    ->default(30),
                TextInput::make('retry_attempts')
                    ->numeric()
                    ->default(3),
                Toggle::make('is_default'),
                TextInput::make('min_amount')
                    ->numeric()
                    ->default(0.0),
                TextInput::make('max_amount')
                    ->numeric()
                    ->default(100000.0),
                Textarea::make('supported_countries')
                    ->default(null)
                    ->columnSpanFull(),
            ]);
    }
}
