<?php

namespace App\Filament\Resources\Announcements\Schemas;

use Filament\Schemas\Components\Section;
use Filament\Schemas\Components\TextInput;
use Filament\Schemas\Components\Textarea;
use Filament\Schemas\Components\Select;
use Filament\Schemas\Components\DateTimePicker;
use Filament\Schemas\Components\Toggle;
use Filament\Schemas\Schema;

class AnnouncementForm
{
    public static function configure(Schema $schema): Schema
    {
        return $schema
            ->schema([
                Section::make('Announcement Details')
                    ->schema([
                        TextInput::make('title')
                            ->required()
                            ->maxLength(255)
                            ->placeholder('Enter announcement title'),

                        Textarea::make('message')
                            ->required()
                            ->rows(5)
                            ->placeholder('Enter announcement message...'),

                        Select::make('type')
                            ->required()
                            ->options([
                                'info' => 'Information',
                                'success' => 'Success',
                                'warning' => 'Warning',
                                'error' => 'Error',
                            ])
                            ->default('info'),

                        DateTimePicker::make('expires_at')
                            ->label('Expiry Date')
                            ->helperText('Leave empty for no expiration')
                            ->minDate(now()),

                        Toggle::make('is_read')
                            ->label('Mark as Read')
                            ->default(false),
                    ])
                    ->columns(1),
            ]);
    }
}
