<?php

namespace App\Data;

use Spatie\LaravelData\Data;
use Spatie\TypeScriptTransformer\Attributes\TypeScript;
use Spatie\TypeScriptTransformer\Attributes\TypeScriptType; // <- this one is required

#[TypeScript]
class UserShowData extends Data
{
    public function __construct(
        public string $id,
        public string $name,
        public string $email,
        public ?bool $isVerified = null,

        // Trick: remove the `?` from PHP, handle null in the TS union
        #[TypeScriptType("'unverified' | 'api_pending' | 'api_verified' | 'api_failed' | 'admin_approved' | 'admin_rejected' | null")]
        public string $kyc_status = 'unverified',

        public ?string $bvn = null,
        public ?string $nin = null
    ) {}
}