<?php

namespace App\Console;

use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Foundation\Console\Kernel as ConsoleKernel;

class Kernel extends ConsoleKernel
{
    /**
     * The Artisan commands provided by your application.
     *
     * @var array
     */
    protected $commands = [
        // Register your commands here if needed
        \App\Console\Commands\SyncClubKonnectTransactions::class,
        \App\Console\Commands\SyncProviderBalances::class,
    ];

    protected $middlewareGroups = [
        'web' => [
            // ... other middleware
            \App\Http\Middleware\ShareNotificationCount::class,
        ],
    ];

    /**
     * Define the application's command schedule.
     *
     * @param  \Illuminate\Console\Scheduling\Schedule  $schedule
     * @return void
     */
    protected function schedule(Schedule $schedule)
    {
        // Sync ClubKonnect transactions every 5 minutes
        $schedule->command('clubkonnect:sync-transactions')->everyFiveMinutes();

        // Sync provider balances every 15 minutes
        $schedule->command('providers:sync-balances')->everyFifteenMinutes();

        // Optionally, run the queue worker if you're using queues
        // $schedule->command('queue:work --stop-when-empty')->everyMinute();

        // Clear application cache daily at midnight
        // $schedule->command('cache:clear')->daily();

        // Backup database daily
        // $schedule->command('db:backup')->daily();
    }

    /**
     * Register the commands for the application.
     *
     * @return void
     */
    protected function commands()
    {
        $this->load(__DIR__ . '/Commands');

        require base_path('routes/console.php');
    }
}
