<?php

namespace App\Console\Commands;

use App\Models\ApiProvider;
use Illuminate\Console\Command;
use App\Http\Controllers\AirtimeController;

class SyncProviderBalances extends Command
{
    protected $signature = 'providers:sync-balances';
    protected $description = 'Sync balances for all API providers';

    public function handle()
    {
        $providers = ApiProvider::where('is_active', true)->get();

        foreach ($providers as $provider) {
            $this->info("Checking balance for {$provider->name}...");

            try {
                $balance = $this->checkProviderBalance($provider);

                if ($balance !== null) {
                    $provider->update(['balance' => $balance]);
                    $this->line("✓ {$provider->name}: ₦" . number_format($balance, 2));
                } else {
                    $this->warn("✗ {$provider->name}: Unable to check balance");
                }
            } catch (\Exception $e) {
                $this->error("✗ {$provider->name}: " . $e->getMessage());
            }
        }

        $this->info('Provider balance sync completed.');
    }

    private function checkProviderBalance($provider)
    {
        switch ($provider->code) {
            case 'clubkonnect':
                return app(AirtimeController::class)->checkClubKonnectBalance($provider);

            case 'vtu_ng':
                // Implement VTU.ng balance check
                return $this->checkVtuNgBalance($provider);

            case 'blocvault':
                // Implement Blocvault balance check
                return $this->checkBlocvaultBalance($provider);

            default:
                return $provider->balance;
        }
    }

    private function checkVtuNgBalance($provider)
    {
        // Implement VTU.ng balance check
        // You'll need to make an API call to VTU.ng
        // Example:
        // $response = Http::withHeaders(['Authorization' => 'Bearer ' . $provider->api_key])
        //     ->get($provider->api_url . '/balance');
        // return $response->json()['balance'] ?? 0;

        return $provider->balance; // Placeholder
    }

    private function checkBlocvaultBalance($provider)
    {
        // Implement Blocvault balance check
        return $provider->balance; // Placeholder
    }
}
