<p align="center"><a href="https://laravel.com" target="_blank"><img src="https://raw.githubusercontent.com/laravel/art/master/logo-lockup/5%20SVG/2%20CMYK/1%20Full%20Color/laravel-logolockup-cmyk-red.svg" width="400" alt="Laravel Logo"></a></p>

<p align="center">
<a href="https://github.com/laravel/framework/actions"><img src="https://github.com/laravel/framework/workflows/tests/badge.svg" alt="Build Status"></a>
<a href="https://packagist.org/packages/laravel/framework"><img src="https://img.shields.io/packagist/dt/laravel/framework" alt="Total Downloads"></a>
<a href="https://packagist.org/packages/laravel/framework"><img src="https://img.shields.io/packagist/v/laravel/framework" alt="Latest Stable Version"></a>
<a href="https://packagist.org/packages/laravel/framework"><img src="https://img.shields.io/packagist/l/laravel/framework" alt="License"></a>
</p>

## About Laravel

Laravel is a web application framework with expressive, elegant syntax. We believe development must be an enjoyable and creative experience to be truly fulfilling. Laravel takes the pain out of development by easing common tasks used in many web projects, such as:

- [Simple, fast routing engine](https://laravel.com/docs/routing).
- [Powerful dependency injection container](https://laravel.com/docs/container).
- Multiple back-ends for [session](https://laravel.com/docs/session) and [cache](https://laravel.com/docs/cache) storage.
- Expressive, intuitive [database ORM](https://laravel.com/docs/eloquent).
- Database agnostic [schema migrations](https://laravel.com/docs/migrations).
- [Robust background job processing](https://laravel.com/docs/queues).
- [Real-time event broadcasting](https://laravel.com/docs/broadcasting).

Laravel is accessible, powerful, and provides tools required for large, robust applications.

## Learning Laravel

Laravel has the most extensive and thorough [documentation](https://laravel.com/docs) and video tutorial library of all modern web application frameworks, making it a breeze to get started with the framework. You can also check out [Laravel Learn](https://laravel.com/learn), where you will be guided through building a modern Laravel application.

If you don't feel like reading, [Laracasts](https://laracasts.com) can help. Laracasts contains thousands of video tutorials on a range of topics including Laravel, modern PHP, unit testing, and JavaScript. Boost your skills by digging into our comprehensive video library.

## Laravel Sponsors

We would like to extend our thanks to the following sponsors for funding Laravel development. If you are interested in becoming a sponsor, please visit the [Laravel Partners program](https://partners.laravel.com).

### Premium Partners

- **[Vehikl](https://vehikl.com)**
- **[Tighten Co.](https://tighten.co)**
- **[Kirschbaum Development Group](https://kirschbaumdevelopment.com)**
- **[64 Robots](https://64robots.com)**
- **[Curotec](https://www.curotec.com/services/technologies/laravel)**
- **[DevSquad](https://devsquad.com/hire-laravel-developers)**
- **[Redberry](https://redberry.international/laravel-development)**
- **[Active Logic](https://activelogic.com)**

## Contributing

Thank you for considering contributing to the Laravel framework! The contribution guide can be found in the [Laravel documentation](https://laravel.com/docs/contributions).

## Code of Conduct

In order to ensure that the Laravel community is welcoming to all, please review and abide by the [Code of Conduct](https://laravel.com/docs/contributions#code-of-conduct).

## Security Vulnerabilities

If you discover a security vulnerability within Laravel, please send an e-mail to Taylor Otwell via [taylor@laravel.com](mailto:taylor@laravel.com). All security vulnerabilities will be promptly addressed.

## License

The Laravel framework is open-sourced software licensed under the [MIT license](https://opensource.org/licenses/MIT).

```
vtusiteblk1
├─ .editorconfig
├─ app
│  ├─ Console
│  │  ├─ Commands
│  │  │  ├─ SyncClubKonnectTransactions.php
│  │  │  └─ SyncProviderBalances.php
│  │  └─ Kernel.php
│  ├─ Data
│  │  ├─ UserShowData.php
│  │  └─ WalletShowData.php
│  ├─ Filament
│  │  ├─ Pages
│  │  │  └─ Settings.php
│  │  ├─ Resources
│  │  │  ├─ AnnouncementResource.php.bak
│  │  │  ├─ Announcements
│  │  │  │  ├─ AnnouncementResource.php
│  │  │  │  ├─ Pages
│  │  │  │  │  ├─ CreateAnnouncement.php
│  │  │  │  │  ├─ EditAnnouncement.php
│  │  │  │  │  └─ ListAnnouncements.php
│  │  │  │  ├─ Schemas
│  │  │  │  │  └─ AnnouncementForm.php
│  │  │  │  └─ Tables
│  │  │  │     └─ AnnouncementsTable.php
│  │  │  ├─ ApiProviders
│  │  │  │  ├─ ApiProviderResource.php
│  │  │  │  ├─ Pages
│  │  │  │  │  ├─ CreateApiProvider.php
│  │  │  │  │  ├─ EditApiProvider.php
│  │  │  │  │  ├─ ListApiProviders.php
│  │  │  │  │  └─ ViewApiProvider.php
│  │  │  │  ├─ Schemas
│  │  │  │  │  ├─ ApiProviderForm.php
│  │  │  │  │  └─ ApiProviderInfolist.php
│  │  │  │  └─ Tables
│  │  │  │     └─ ApiProvidersTable.php
│  │  │  ├─ Products
│  │  │  │  ├─ Pages
│  │  │  │  │  ├─ CreateProduct.php
│  │  │  │  │  ├─ EditProduct.php
│  │  │  │  │  ├─ ListProducts.php
│  │  │  │  │  └─ ViewProduct.php
│  │  │  │  ├─ ProductResource.php
│  │  │  │  ├─ Schemas
│  │  │  │  │  ├─ ProductForm.php
│  │  │  │  │  └─ ProductInfolist.php
│  │  │  │  └─ Tables
│  │  │  │     └─ ProductsTable.php
│  │  │  ├─ SettingResource.php
│  │  │  ├─ Settings
│  │  │  │  ├─ Pages
│  │  │  │  │  ├─ CreateSetting.php
│  │  │  │  │  ├─ EditSetting.php
│  │  │  │  │  ├─ ListSettings.php
│  │  │  │  │  └─ ViewSetting.php
│  │  │  │  ├─ Schemas
│  │  │  │  │  ├─ SettingForm.php
│  │  │  │  │  └─ SettingInfolist.php
│  │  │  │  └─ Tables
│  │  │  │     └─ SettingsTable.php
│  │  │  ├─ Transactions
│  │  │  │  ├─ Pages
│  │  │  │  │  ├─ CreateTransaction.php
│  │  │  │  │  ├─ EditTransaction.php
│  │  │  │  │  ├─ ListTransactions.php
│  │  │  │  │  └─ ViewTransaction.php
│  │  │  │  ├─ Schemas
│  │  │  │  │  ├─ TransactionForm.php
│  │  │  │  │  └─ TransactionInfolist.php
│  │  │  │  ├─ Tables
│  │  │  │  │  └─ TransactionsTable.php
│  │  │  │  └─ TransactionResource.php
│  │  │  ├─ UserMessages
│  │  │  │  ├─ Pages
│  │  │  │  │  ├─ CreateUserMessage.php
│  │  │  │  │  ├─ EditUserMessage.php
│  │  │  │  │  ├─ ListUserMessages.php
│  │  │  │  │  └─ ViewUserMessage.php
│  │  │  │  ├─ Schemas
│  │  │  │  │  ├─ UserMessageForm.php
│  │  │  │  │  └─ UserMessageInfolist.php
│  │  │  │  ├─ Tables
│  │  │  │  │  └─ UserMessagesTable.php
│  │  │  │  └─ UserMessageResource.php
│  │  │  ├─ Users
│  │  │  │  ├─ Pages
│  │  │  │  │  ├─ CreateUser.php
│  │  │  │  │  ├─ EditUser.php
│  │  │  │  │  ├─ ListUsers.php
│  │  │  │  │  └─ ViewUser.php
│  │  │  │  ├─ Schemas
│  │  │  │  │  ├─ UserForm.php
│  │  │  │  │  └─ UserInfolist.php
│  │  │  │  ├─ Tables
│  │  │  │  │  └─ UsersTable.php
│  │  │  │  └─ UserResource.php
│  │  │  ├─ Wallets
│  │  │  │  ├─ Pages
│  │  │  │  │  ├─ CreateWallet.php
│  │  │  │  │  ├─ EditWallet.php
│  │  │  │  │  ├─ ListWallets.php
│  │  │  │  │  └─ ViewWallet.php
│  │  │  │  ├─ Schemas
│  │  │  │  │  ├─ WalletForm.php
│  │  │  │  │  └─ WalletInfolist.php
│  │  │  │  ├─ Tables
│  │  │  │  │  └─ WalletsTable.php
│  │  │  │  └─ WalletResource.php
│  │  │  └─ WalletTransactions
│  │  │     ├─ Pages
│  │  │     │  ├─ CreateWalletTransaction.php
│  │  │     │  ├─ EditWalletTransaction.php
│  │  │     │  ├─ ListWalletTransactions.php
│  │  │     │  └─ ViewWalletTransaction.php
│  │  │     ├─ Schemas
│  │  │     │  ├─ WalletTransactionForm.php
│  │  │     │  └─ WalletTransactionInfolist.php
│  │  │     ├─ Tables
│  │  │     │  └─ WalletTransactionsTable.php
│  │  │     └─ WalletTransactionResource.php
│  │  └─ Widgets
│  │     ├─ LatestTransactions.php
│  │     ├─ StatsOverview.php
│  │     ├─ wallet-summary.blade.php
│  │     └─ WalletSummary.php
│  ├─ Http
│  │  ├─ Controllers
│  │  │  ├─ AirtimeController.php
│  │  │  ├─ Api
│  │  │  │  └─ NotificationController.php
│  │  │  ├─ Auth
│  │  │  │  ├─ AuthenticatedSessionController.php
│  │  │  │  ├─ ConfirmablePasswordController.php
│  │  │  │  ├─ EmailVerificationNotificationController.php
│  │  │  │  ├─ EmailVerificationPromptController.php
│  │  │  │  ├─ NewPasswordController.php
│  │  │  │  ├─ PasswordController.php
│  │  │  │  ├─ PasswordResetLinkController.php
│  │  │  │  ├─ RegisteredUserController.php
│  │  │  │  └─ VerifyEmailController.php
│  │  │  ├─ CableTVController.php
│  │  │  ├─ Controller.php
│  │  │  ├─ DashboardController.php
│  │  │  ├─ DataController.php
│  │  │  ├─ ElectricityController.php
│  │  │  ├─ HistoryController.php
│  │  │  ├─ KycController.php
│  │  │  ├─ PaymentController.php
│  │  │  ├─ ProfileController.php
│  │  │  ├─ TransactionController.php
│  │  │  └─ WalletController.php
│  │  ├─ Middleware
│  │  │  ├─ HandleInertiaRequests.php
│  │  │  └─ ShareNotificationCount.php
│  │  └─ Requests
│  │     ├─ Auth
│  │     │  └─ LoginRequest.php
│  │     └─ ProfileUpdateRequest.php
│  ├─ Models
│  │  ├─ ApiProvider.php
│  │  ├─ Network.php
│  │  ├─ Product.php
│  │  ├─ Setting.php
│  │  ├─ Transaction.php
│  │  ├─ TransactionFee.php
│  │  ├─ User.php
│  │  ├─ UserMessage.php
│  │  ├─ VirtualAccount.php
│  │  ├─ Wallet.php
│  │  ├─ WalletHistory.php
│  │  └─ WalletTransaction.php
│  ├─ Observers
│  │  └─ SettingObserver.php
│  ├─ Providers
│  │  ├─ AppServiceProvider.php
│  │  ├─ Filament
│  │  │  ├─ AdminPanelProvider.php
│  │  │  └─ AppPanelProvider.php
│  │  ├─ RouteServiceProvider.php
│  │  └─ SettingsServiceProvider.php
│  ├─ Services
│  │  ├─ AccountService.php
│  │  ├─ ClubKonnectService.php
│  │  ├─ ExternalVtuService.php
│  │  ├─ MonnifyService.php
│  │  ├─ PurchaseService.php
│  │  └─ WalletHistoryService.php
│  └─ Traits
│     └─ HandlesSystemAnnouncements.php
├─ artisan
├─ bootstrap
│  ├─ app.php
│  ├─ cache
│  │  ├─ packages.php
│  │  └─ services.php
│  └─ providers.php
├─ cd
├─ components.json
├─ composer.json
├─ composer.lock
├─ config
│  ├─ app.php
│  ├─ auth.php
│  ├─ cache.php
│  ├─ database.php
│  ├─ filesystems.php
│  ├─ logging.php
│  ├─ mail.php
│  ├─ monnify.php
│  ├─ services.php
│  ├─ session.php
│  └─ typescript-transformer.php
├─ database
│  ├─ factories
│  │  └─ UserFactory.php
│  ├─ migrations
│  │  ├─ 2026_01_05_104409_create_products_table.php
│  │  ├─ 2026_01_05_104410_create_networks_table.php
│  │  ├─ 2026_01_05_104411_create_transactions_table.php
│  │  ├─ 2026_01_05_105122_update_products_table_for_clubkonnect.php
│  │  ├─ 2026_01_09_091819_create_wallet_transactions_table.php
│  │  ├─ 2026_01_10_060759_create_user_messages_table.php
│  │  ├─ 2026_01_11_052928_create_settings_table.php
│  │  └─ 2026_01_12_065638_create_user_message_assignments_table.php
│  ├─ queue.php
│  └─ seeders
│     ├─ ClubKonnectAirtimeSeeder.php
│     ├─ ClubKonnectDataSeeder.php
│     ├─ DatabaseSeeder.php
│     ├─ NetworkSeeder.php
│     └─ SettingsSeeder.php
├─ package-lock.json
├─ package.json
├─ phpunit.xml
├─ postcss.config.js
├─ public
│  ├─ .htaccess
│  ├─ check.php
│  ├─ css
│  │  └─ filament
│  │     └─ filament
│  │        └─ app.css
│  ├─ favicon.ico
│  ├─ favicons
│  ├─ fonts
│  │  └─ filament
│  │     └─ filament
│  │        └─ inter
│  │           ├─ index.css
│  │           ├─ inter-cyrillic-ext-wght-normal-ASVAGXXE.woff2
│  │           ├─ inter-cyrillic-ext-wght-normal-XKHXBTUO.woff2
│  │           ├─ inter-cyrillic-wght-normal-EWLSKVKN.woff2
│  │           ├─ inter-cyrillic-wght-normal-R5CMSONN.woff2
│  │           ├─ inter-greek-ext-wght-normal-7GGTF7EK.woff2
│  │           ├─ inter-greek-ext-wght-normal-ZEVLMORV.woff2
│  │           ├─ inter-greek-wght-normal-AXVTPQD5.woff2
│  │           ├─ inter-greek-wght-normal-N43DBLU2.woff2
│  │           ├─ inter-latin-ext-wght-normal-5SRY4DMZ.woff2
│  │           ├─ inter-latin-ext-wght-normal-GZCIV3NH.woff2
│  │           ├─ inter-latin-ext-wght-normal-HA22NDSG.woff2
│  │           ├─ inter-latin-wght-normal-NRMW37G5.woff2
│  │           ├─ inter-latin-wght-normal-O25CN4JL.woff2
│  │           ├─ inter-latin-wght-normal-OPIJAQLS.woff2
│  │           ├─ inter-vietnamese-wght-normal-CE5GGD3W.woff2
│  │           └─ inter-vietnamese-wght-normal-TWG5UU7E.woff2
│  ├─ index.php
│  ├─ js
│  │  └─ filament
│  │     ├─ actions
│  │     │  └─ actions.js
│  │     ├─ filament
│  │     │  ├─ app.js
│  │     │  └─ echo.js
│  │     ├─ forms
│  │     │  └─ components
│  │     │     ├─ checkbox-list.js
│  │     │     ├─ code-editor.js
│  │     │     ├─ color-picker.js
│  │     │     ├─ date-time-picker.js
│  │     │     ├─ file-upload.js
│  │     │     ├─ key-value.js
│  │     │     ├─ markdown-editor.js
│  │     │     ├─ rich-editor.js
│  │     │     ├─ select.js
│  │     │     ├─ slider.js
│  │     │     ├─ tags-input.js
│  │     │     └─ textarea.js
│  │     ├─ notifications
│  │     │  └─ notifications.js
│  │     ├─ schemas
│  │     │  ├─ components
│  │     │  │  ├─ actions.js
│  │     │  │  ├─ tabs.js
│  │     │  │  └─ wizard.js
│  │     │  └─ schemas.js
│  │     ├─ support
│  │     │  └─ support.js
│  │     ├─ tables
│  │     │  ├─ components
│  │     │  │  └─ columns
│  │     │  │     ├─ checkbox.js
│  │     │  │     ├─ select.js
│  │     │  │     ├─ text-input.js
│  │     │  │     └─ toggle.js
│  │     │  └─ tables.js
│  │     └─ widgets
│  │        └─ components
│  │           ├─ chart.js
│  │           └─ stats-overview
│  │              └─ stat
│  │                 └─ chart.js
│  └─ robots.txt
├─ README.md
├─ resources
│  ├─ css
│  │  └─ app.css
│  ├─ js
│  │  ├─ app.tsx
│  │  ├─ bootstrap.ts
│  │  ├─ Components
│  │  │  ├─ ApplicationLogo.tsx
│  │  │  ├─ AvatarUpload.tsx
│  │  │  ├─ Checkbox.tsx
│  │  │  ├─ DangerButton.tsx
│  │  │  ├─ Dropdown.tsx
│  │  │  ├─ InputError.tsx
│  │  │  ├─ InputLabel.tsx
│  │  │  ├─ Modal.tsx
│  │  │  ├─ NavLink.tsx
│  │  │  ├─ NotificationDropdown.tsx
│  │  │  ├─ NotificationModal.tsx
│  │  │  ├─ PrimaryButton.tsx
│  │  │  ├─ ResponsiveNavLink.tsx
│  │  │  ├─ SecondaryButton.tsx
│  │  │  ├─ TextInput.tsx
│  │  │  └─ ui
│  │  │     ├─ alert.tsx
│  │  │     ├─ avatar.tsx
│  │  │     ├─ badge.tsx
│  │  │     ├─ breadcrumb.tsx
│  │  │     ├─ button.tsx
│  │  │     ├─ card.tsx
│  │  │     ├─ collapsible.tsx
│  │  │     ├─ dialog.tsx
│  │  │     ├─ dropdown-menu.tsx
│  │  │     ├─ input.tsx
│  │  │     ├─ label.tsx
│  │  │     ├─ select.tsx
│  │  │     ├─ separator.tsx
│  │  │     ├─ sheet.tsx
│  │  │     ├─ sidebar.tsx
│  │  │     ├─ skeleton.tsx
│  │  │     ├─ switch.tsx
│  │  │     ├─ tabs.tsx
│  │  │     └─ tooltip.tsx
│  │  ├─ hooks
│  │  │  └─ use-mobile.tsx
│  │  ├─ Layouts
│  │  │  ├─ AppLayout.tsx
│  │  │  ├─ AuthenticatedLayout.tsx
│  │  │  ├─ GuestLayout.tsx
│  │  │  └─ Partials
│  │  │     ├─ AppSidebar.tsx
│  │  │     ├─ NavMain.tsx
│  │  │     └─ NavUser.tsx
│  │  ├─ lib
│  │  │  └─ utils.ts
│  │  ├─ Pages
│  │  │  ├─ Auth
│  │  │  │  ├─ ConfirmPassword.tsx
│  │  │  │  ├─ ForgotPassword.tsx
│  │  │  │  ├─ Login.tsx
│  │  │  │  ├─ Register.tsx
│  │  │  │  ├─ ResetPassword.tsx
│  │  │  │  └─ VerifyEmail.tsx
│  │  │  ├─ Dashboard.tsx
│  │  │  ├─ Footer.tsx
│  │  │  ├─ Header.tsx
│  │  │  ├─ Products
│  │  │  │  ├─ BuyAirtime.tsx
│  │  │  │  ├─ BuyCableTV.tsx
│  │  │  │  └─ BuyData.tsx
│  │  │  ├─ Profile
│  │  │  │  ├─ Edit.tsx
│  │  │  │  ├─ Partials
│  │  │  │  │  ├─ DeleteUserForm.tsx
│  │  │  │  │  ├─ UpdatePasswordForm.tsx
│  │  │  │  │  └─ UpdateProfileInformationForm.tsx
│  │  │  │  └─ WalletHistory.tsx
│  │  │  ├─ Transactions
│  │  │  │  └─ Index.tsx
│  │  │  ├─ Wallet
│  │  │  │  ├─ Fund.tsx
│  │  │  │  └─ History.tsx
│  │  │  └─ Welcome.tsx
│  │  ├─ ssr.tsx
│  │  └─ types
│  │     ├─ App.d.ts
│  │     ├─ global.d.ts
│  │     ├─ index.d.ts
│  │     └─ vite-env.d.ts
│  └─ views
│     ├─ app.blade.php
│     ├─ components
│     │  ├─ dynamic-favicon.blade.php
│     │  └─ dynamic-logo.blade.php
│     ├─ filament
│     │  ├─ pages
│     │  │  └─ settings.blade.php
│     │  └─ widgets
│     │     └─ wallet-summary.blade.php
│     └─ layouts
│        └─ app.blade.php
├─ routes
│  ├─ auth.php
│  ├─ console.php
│  └─ web.php
├─ storage
│  ├─ app
│  │  ├─ private
│  │  └─ public
│  │     └─ avatars
│  │        ├─ 8hkwRSYqpqmIJsGNgO1tEM3gdZx6ReXrAlgci5y4.jpg
│  │        ├─ Btrhq0SzDiIVsdYCDGYDEw0M5YgQSQ8r4JvyBnW5.jpg
│  │        ├─ sYtDtfZoWFarbKDRCbDCLbNKlinylgrIJXUVWDoT.png
│  │        └─ tmWhnfMC3Tca2vEFWsoPtlNMC2k66EvWAlRVrlMb.jpg
│  ├─ framework
│  │  ├─ cache
│  │  │  └─ data
│  │  ├─ sessions
│  │  ├─ testing
│  │  └─ views
│  │     ├─ 052268e86df0e1f8b7e570b59b4cc290.php
│  │     ├─ 072e753b1bd6dd9c70ebac7aa683f180.php
│  │     ├─ 09058c1c798128f2ad0183f53cd4036c.php
│  │     ├─ 09e88f778626538ecf3d813eb6331d75.php
│  │     ├─ 0afa2cc112ff9d35e67dc74bf9c3baf5.php
│  │     ├─ 0cb4f5e6661cd0afded627a00eeb426e.php
│  │     ├─ 11e3cae895f1bffc4dc6113e86bcd160.php
│  │     ├─ 17d57edf9cffd802cdc2cef8752ea79a.php
│  │     ├─ 17d8f362a359bba9a859f65abca7e470.php
│  │     ├─ 185f383b08598db2c7e0ae872ccf656d.php
│  │     ├─ 201a393da7ec037764c4a8ed2b9f357d.php
│  │     ├─ 206b4b74a75e43b30e5deb64cae6216f.php
│  │     ├─ 23b695d7c51f68d9f2fd1ae0f01a5713.php
│  │     ├─ 244e15056df68a80552f39654252569a.php
│  │     ├─ 24b7cbe725b2072526c28ec9d0ddb4a0.php
│  │     ├─ 24bfee7d4adb47e4339c27e1b7608f61.php
│  │     ├─ 2596dc4668a826f96ec9a0c06c00d820.php
│  │     ├─ 25ff28d1fcbb4285652d4cf4c0b549d3.php
│  │     ├─ 270a1376e6a6e05d096891b97b20736b.php
│  │     ├─ 278130788a311470b6c3516c1935acbc.php
│  │     ├─ 282e43ba7eb617134e51c651e8fac3b6.php
│  │     ├─ 2cd11a879a01923108054093b9b2b361.php
│  │     ├─ 35246400d98973c1766978cd61a824ce.php
│  │     ├─ 3716aa7316ae8d319de8152932f661dd.php
│  │     ├─ 3d5b160a1f42cda5b565f1d0aa600dae.php
│  │     ├─ 41d4e29bb80345bf6cd6a0f8a90d2227.php
│  │     ├─ 4235699eeca98f30f83b70ca217216d0.php
│  │     ├─ 47fb9d6b5a4cb055c451a58f9997637a.php
│  │     ├─ 4943bc92ebba41e8b0e508149542e0ad.blade.php
│  │     ├─ 4ba9c14f72cfb1148c44ee5092efb3a0.php
│  │     ├─ 50919e1cc81d9315abb280fbb328e92c.php
│  │     ├─ 552d5de6794611fd4adc5b99ae2e9164.php
│  │     ├─ 5721d41e6359647f61f94f725549c56b.php
│  │     ├─ 581a026bd7f6f504189da15de1b4fc15.php
│  │     ├─ 5c576cab216a019fb5c952b7b64e753a.php
│  │     ├─ 5eb8c5fdeba1e0a90ff84fee57b91530.php
│  │     ├─ 5ecb096b9629cf91609aeb1c7fd94ebe.php
│  │     ├─ 5fa7da1b979f35ed5b94834ffe74f894.php
│  │     ├─ 5fdb1244156fab051c719663debc1238.php
│  │     ├─ 63897468a732ee1bb9fa097b90c05109.php
│  │     ├─ 66ab942e9a51d8a2d167770b1f7d1305.php
│  │     ├─ 6781b13cc7e009b4cb0a0edd7eb98952.php
│  │     ├─ 6b69a07fe7c5e87c913bd532c549da2d.php
│  │     ├─ 6d4d7a25af06a4b3b96612f1ccbb2547.php
│  │     ├─ 6f468f92d2c5a1e05204bebc0c9daf4d.php
│  │     ├─ 71de20169ee820026a313114eba8aa5a.php
│  │     ├─ 720921e232084e8b92e2f9f3d12a4dd4.php
│  │     ├─ 7267562ad8f1a7b96a1dafeebb839c58.php
│  │     ├─ 72e5242e47ba7641bb99ca9aca916665.php
│  │     ├─ 75a8c21b4a05242599094c23f9090709.php
│  │     ├─ 762361d1d53d012da370820d94eaff2b.php
│  │     ├─ 7861ddf4f45f185550befeae066c5152.php
│  │     ├─ 7a5db97be04fbefd8949583a92901958.php
│  │     ├─ 7ae7e1df550eaaf01b5e277590af8a23.php
│  │     ├─ 7b7bc740e08a130fcca2d11ea132028f.php
│  │     ├─ 7cb16b55bd29db4ac3cee44992d39d5e.php
│  │     ├─ 7efa8d8730e6e64b895c482f47ff6151.blade.php
│  │     ├─ 7f52d95a10ee75cdbb999ce60ec29f52.php
│  │     ├─ 7fceb36c71ccda66afe9e23087002b60.php
│  │     ├─ 7fe015d41c578389caeecf47d5986d2b.php
│  │     ├─ 81867c52518c3fb24e4c8b7aa4332f39.php
│  │     ├─ 818e25a27ad3f62fdfaa724b41f5f6ea.php
│  │     ├─ 81af9fe9751588afacc2ac18ae95bb85.php
│  │     ├─ 84da8a074b4dd806a46ffd3b2ff091af.php
│  │     ├─ 8807418bf11d8f3a9451fbf4e3f8b34f.php
│  │     ├─ 880c5a6938a47c272365787b052ac1de.php
│  │     ├─ 884f7127a30ecc31c3b3c08fa5677815.php
│  │     ├─ 8c25f57c171920bb1d51e0c65044e2bf.php
│  │     ├─ 8c767d4171b373358191a7cd78838e5e.php
│  │     ├─ 90b98557413637a020fc7ec6664f4cf9.php
│  │     ├─ 90f735238798789131af79c1a93946f8.php
│  │     ├─ 955a7397354bbb01f2313f5863d07193.php
│  │     ├─ 9a61bb8dbf1d39e0724d91f0c43f2d53.php
│  │     ├─ 9b0aa906eb507785d5e713f2ff316d37.blade.php
│  │     ├─ 9c4f52fb275b9aecac482a982ea24668.php
│  │     ├─ a09791d87e82e1816007541ae096c313.php
│  │     ├─ a7984ce43f48bb2da7b177b74516fc39.php
│  │     ├─ aa2f42f60dbd4f5b2b520c3cebe86b36.php
│  │     ├─ af51fe5345eb855c819eb5857ea07201.php
│  │     ├─ b041370095e95980439cce6ec04ca23f.php
│  │     ├─ b1915828ad925d4a0296cd77445d94ad.php
│  │     ├─ b2f40a07fea676318a118065eecdd21c.php
│  │     ├─ b567f1486dc06e57e9802b76ac2c3a8a.php
│  │     ├─ b8fa57ff1a741377708e7134f8d0c767.php
│  │     ├─ b97df857ddd8bfa965272bcd6e6b0ccd.php
│  │     ├─ b9dc37e6f949f93027bdbfa0f129fa4e.php
│  │     ├─ ba1e987e768470171981bb381a6771ed.php
│  │     ├─ bdfee1c24702d71f7ce46a4969dc6ed2.php
│  │     ├─ bf45bde4bc825eca6c14abec08b47fce.php
│  │     ├─ c0d3bd2d81fa9004266f6ad939e64ffb.php
│  │     ├─ c78cffd2ba6421b696d6f0ed4b248f5b.php
│  │     ├─ c89bd8da0a18a09f69879ddaed4dc0a3.php
│  │     ├─ d0412847e40fae5cdc0ae00a9d44ab9e.php
│  │     ├─ d34ca3eeb82d45c5db643a81cd0ebf56.php
│  │     ├─ da4024d4660ac6be041ce7ecc15ee307.blade.php
│  │     ├─ e45ca2140ed0512715080e25d381a8c2.php
│  │     ├─ e50e6658a697a6d6781d77f1719e34be.php
│  │     ├─ e7ea0f3fe2595d9422f052c8b6025073.php
│  │     ├─ ebff4a2bb53ed264c897066b76883afe.php
│  │     ├─ ec17911e74e489a4b2e656253b4cef51.php
│  │     ├─ ec94d02676283f8066cc9a48fa22db2e.php
│  │     ├─ ed6d8e83746a7f5b0b607e320a0e4558.php
│  │     ├─ ee494161ab775632997e5b0112c79942.php
│  │     ├─ ee599ceb20dee18dc82820106e6b0040.php
│  │     ├─ eefb24ab759bb739a0ae3f606f9a426d.php
│  │     ├─ f0185ed6275432e58b4b93e14c03efe2.php
│  │     ├─ f08aebf036ee2bd3413464b08b8ac4d0.php
│  │     ├─ f159f774a17cd1ecdd532502a931d816.php
│  │     ├─ f35bd7e68eab868cbfe9d5a29fc3f574.php
│  │     ├─ f591fc1fe00c09a023b575878f6726ce.php
│  │     ├─ f8c86079b38538cec55f2ec90f7aff5f.php
│  │     ├─ fa1d30a70eab6c2efc06267c1419eddb.php
│  │     └─ fe63a3461acb5c300a104d6657f85062.php
│  └─ logs
├─ tailwind.config.js
├─ tests
│  ├─ Feature
│  │  ├─ Auth
│  │  │  ├─ AuthenticationTest.php
│  │  │  ├─ EmailVerificationTest.php
│  │  │  ├─ PasswordConfirmationTest.php
│  │  │  ├─ PasswordResetTest.php
│  │  │  ├─ PasswordUpdateTest.php
│  │  │  └─ RegistrationTest.php
│  │  ├─ ExampleTest.php
│  │  └─ ProfileTest.php 
│  ├─ Pest.php
│  ├─ TestCase.php
│  └─ Unit
│     └─ ExampleTest.php
├─ tsconfig.json
└─ vite.config.js

```